package de.fhdw.wtf.facade;

import de.fhdw.wtf.common.ast.Name;
import de.fhdw.wtf.common.exception.walker.TaskException;

/**
 * A class that represents exceptions that occure when a Name for a Type is already taken.
 */
public class TypeNameAlreadyTakenException extends TaskException {
	
	/**
	 * Unique ID for serialization.
	 */
	private static final long serialVersionUID = 2026009714977507151L;
	
	/**
	 * Creates a new TypeNameAlreadyTakenException for <code>typeName</code>.
	 * 
	 * @param typeName
	 *            Name that is already taken
	 */
	public TypeNameAlreadyTakenException(final Name typeName) {
		super(message(typeName));
	}
	
	/**
	 * Creates a String message that the Name is already taken.
	 * 
	 * @param typeName
	 *            The typeName that is already taken.
	 * @return A message as String.
	 */
	private static String message(final Name typeName) {
		return "The name \"" + typeName.toString() + "\" is already taken.";
	}
}
