package de.fhdw.wtf.generator.java.generatorModel;

/**
 * Represents generated comments or comments which are imported by ImportAllFromClipperTask. It is used for the
 * {@link GeneratorModel}.
 */
public final class GenComment {
	
	/**
	 * Text of the comment.
	 */
	private final String text;
	
	/**
	 * "/**".
	 */
	private static final String COMMENT_START = "/**";
	
	/**
	 * "*".
	 */
	private static final String COMMENT_STAR = " * ";
	
	/**
	 * "*\/".
	 */
	private static final String COMMENT_END = " */";
	
	/**
	 * "\t".
	 */
	private static final String TAB = "\t";
	
	/**
	 * "\n".
	 */
	private static final String NEXTLINE = "\n";
	
	/**
	 * "\\n".
	 */
	private static final String NEXTLINE_REGEX = "\\n";
	
	/**
	 * private constructor for factory pattern.
	 * 
	 * @param text
	 *            : text of comment.
	 */
	private GenComment(final String text) {
		this.text = text;
	}
	
	/**
	 * Factory method for {@link GenComment}.
	 * 
	 * @param text
	 *            : text of comment.
	 * @return : new GenComment.
	 */
	public static GenComment create(final String text) {
		return new GenComment(text);
	}
	
	/**
	 * Creates the java comment structure of plain text with "/**" and "*\/" for start and end of comment.
	 * 
	 * @param text
	 *            : text to be converted to a comment.
	 * @param operationComment
	 *            : signal if the comment is an operation comment.
	 * @return new {@link GenComment}.
	 */
	public static GenComment createFromPlainText(final String text, final boolean operationComment) {
		final StringBuilder result = new StringBuilder();
		result.append(COMMENT_START + NEXTLINE);
		final String[] commentLines = text.split(NEXTLINE_REGEX);
		for (final String commentLine : commentLines) {
			if (operationComment) {
				result.append(TAB);
			}
			result.append(COMMENT_STAR + commentLine + NEXTLINE);
		}
		if (operationComment) {
			result.append(TAB);
		}
		result.append(COMMENT_END);
		return new GenComment(result.toString());
		// FIXME schön machen
	}
	
	/**
	 * Projections.
	 * 
	 * @return text of the comment. If the text is converted to a comment than the java comment structure is contained.
	 */
	public String getText() {
		return this.text;
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (obj instanceof GenComment) {
			final GenComment others = (GenComment) obj;
			return others.getText().equals(this.text);
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return 0;
	}
	
	@Override
	public String toString() {
		return this.text;
	}
}
