package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;

public class GenException extends GenClassClass {
	
	/**
	 * Constructor of {@link GenException}.
	 * 
	 * @param name
	 *            The name of the class and the java-file to generate.
	 * @param attributes
	 *            The attribute the class has.
	 * @param operations
	 *            The operations the class has.
	 * @param modifiers
	 *            The class-modifiers for this class. For example "public".
	 * @param constructors
	 *            The constructor-operations for this class.
	 * @param impl
	 *            The interfaces the class implements.
	 * @param comment
	 *            The comment that describes this class.
	 * @param packag
	 *            The package the class will be generated in.
	 * @param nonGenPart
	 *            Additional lines of code.
	 */
	protected GenException(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> impl,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenPackage packag,
			final GenComment comment,
			final String nonGenPart) {
		super(name, operations, impl, attributes, modifiers, constructors, null, packag, comment, nonGenPart);
		this.setExtend(GenExternalClassClass.getInstance("de.fhdw.wtf.context.model.AbstractExceptionLayer"));
	}
	
	/**
	 * Creates an object of {@link GenException}.
	 * 
	 * @param name
	 *            The name of the class and the java-file to generate.
	 * @param attributes
	 *            The attribute the class has.
	 * @param operations
	 *            The operations the class has.
	 * @param modifiers
	 *            The class-modifiers for this class. For example "public".
	 * @param constructors
	 *            The constructor-operations for this class.
	 * @param impl
	 *            The interfaces the class implements.
	 * @param comment
	 *            The comment that describes this class.
	 * @param packag
	 *            The package the class will be generated in.
	 * @param nonGenPart
	 *            Additional lines of code.
	 * 
	 * @return new {@link GenException}-Object.
	 */
	public static GenException create(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> impl,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenPackage packag,
			final GenComment comment,
			final String nonGenPart) {
		return new GenException(name, operations, impl, attributes, modifiers, constructors, packag, comment,
				nonGenPart);
	}
	
	@Override
	public void accept(final GenClassClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenClassClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
	@Override
	public <Y extends Exception> void accept(final GenClassClassVisitorException<Y> visitor) throws Y {
		visitor.handle(this);
	}
}
