package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerationModelItemVisitor;

public final class GenJoinpoint extends GenerationModelItem {
	
	private final String methodBody;
	
	private GenJoinpoint(final String name, final String methodBody) {
		super(name);
		this.methodBody = methodBody;
	}
	
	public static GenJoinpoint create(final String name, final String methodBody) {
		return new GenJoinpoint(name, methodBody);
	}
	
	@Override
	public void accept(final GenerationModelItemVisitor visitor) {
		visitor.handle(this);
	}
	
	public String getMethodBody() {
		return this.methodBody;
	}
	
}
