package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenCollectionTypeVisitor;

/**
 * Represents a list type in the generator model.
 */
public class GenMutableList extends GenCollectionType {
	
	/**
	 * Name of the Context class representing lists.
	 */
	private static final String MUTABLE_LIST_TYPENAME = "MutableList";
	
	/**
	 * Creates a {@link GenMutableList} object.
	 *
	 * @param value
	 *            The list's value type.
	 */
	protected GenMutableList(final GenType value) {
		super(MUTABLE_LIST_TYPENAME, value);
	}
	
	/**
	 * Creates a {@link GenMutableList} object.
	 *
	 * @param value
	 *            The list's value type.
	 * @return A {@link GenMutableList} object.
	 */
	public static GenMutableList create(final GenType value) {
		return new GenMutableList(value);
	}
	
	@Override
	public String getFullyQualifiedTypeNameWithGenericArguments() {
		return this.getFullyQualifiedTypeName() + GEN_OPEN
				+ this.getType().getFullyQualifiedTypeNameWithGenericArguments() + GEN_CLOSE;
	}
	
	@Override
	public void accept(final GenCollectionTypeVisitor visitor) {
		visitor.handle(this);
	}
	
}
