package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitorReturn;

/**
 * This class is a substitute for a real type.
 * 
 */
public final class GenTypeReferenceByReference implements GenTypeReference {
	
	/**
	 * The referenced {@link GenType}.
	 */
	private final GenType typ;
	
	/**
	 * Instantiates a new {@link GenTypeReferenceByReference} that references <code>typ</code>.
	 * 
	 * @param typ
	 *            The type to reference.
	 */
	private GenTypeReferenceByReference(final GenType typ) {
		this.typ = typ;
	}
	
	/**
	 * Returns the referenced {@link GenType}.
	 * 
	 * @return {@link GenType}
	 */
	public GenType getTyp() {
		return this.typ;
	}
	
	/**
	 * Creates a new {@link GenTypeReferenceByReference} that references <code>typ</code>.
	 * 
	 * @param typ
	 *            The type to reference.
	 * @return {@link GenTypeReferenceByReference}
	 */
	public static GenTypeReferenceByReference create(final GenType typ) {
		return new GenTypeReferenceByReference(typ);
	}
	
	@Override
	public <T> T accept(final GenTypeReferenceVisitorReturn<T> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public String getName() {
		return this.getTyp().getName();
	}
	
	@Override
	public String getFullyQualifiedName() {
		return this.getTyp().getFullyQualifiedTypeName();
	}
	
	@Override
	public String getFullyQualifiedNameWithGenericArguments() {
		return this.getTyp().getFullyQualifiedTypeNameWithGenericArguments();
	}
	
	@Override
	public void accept(final GenTypeReferenceVisitor visitor) {
		visitor.handle(this);
	}
	
}
