package de.fhdw.wtf.generator.java.generatorModel;

/**
 * An enum that contains all possible visibility modifiers that exist in Java.
 */
public enum GenVisibility {
	/**
	 * public means anyone can see it.
	 */
	PUBLIC("public"),
	/**
	 * protected means only the owner-class subclasses of that class and other classes in the same package can see it.
	 */
	PROTECTED("protected"),
	/**
	 * Per default the owner-class and other classes in the same package can see it.
	 */
	DEFAULT(""),
	/**
	 * private means it can only be seen by the owner-class.
	 */
	PRIVATE("private");
	
	/**
	 * String-representation of the instance of GenVisibility.
	 */
	private final String t;
	
	/**
	 * Instantiates a new GenVisibility.
	 * 
	 * @param t
	 *            String-representation of the instance.
	 */
	GenVisibility(final String t) {
		this.t = t;
	}
	
	@Override
	public String toString() {
		return this.t;
	}
	
	/**
	 * selects the most restricting visibility from a collection of visibilities.
	 * 
	 * @param visibilities
	 *            collection containing visibilities
	 * @return the most restricting visibility
	 */
	public GenVisibility min(final GenVisibility visibilities) {
		boolean vis1Protected = false;
		boolean vis1Default = false;
		
		switch (visibilities) {
		case PUBLIC:
			return this;
		case PROTECTED:
			vis1Protected = true;
			break;
		case PRIVATE:
			return visibilities;
		case DEFAULT:
			vis1Default = true;
			break;
		default:
			break;
		}
		
		if (vis1Default) {
			if (this == GenVisibility.PRIVATE) {
				return this;
			}
		}
		if (vis1Protected) {
			if (this == GenVisibility.DEFAULT || this == GenVisibility.PRIVATE) {
				return this;
			}
		}
		return visibilities;
	}
	
}
