package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;

/**
 * This visitor handles all GenClass-types. Maybe throws an exception.
 * 
 * @param <Y>
 *            The type of exception that can be thrown by handle-methods.
 */
public interface GenClassClassVisitorException<Y extends Exception> {
	
	/**
	 * Handle method for objects of GenException-type.
	 * 
	 * @param e
	 *            GenException to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenException e) throws Y;
	
	/**
	 * Handle method for objects of GenAnyType-type.
	 * 
	 * @param anyType
	 *            GenAnyType to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenAnyType anyType) throws Y;
	
	/**
	 * Handle method for objects of GenJavaException-type.
	 * 
	 * @param javaE
	 *            GenJavaException to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenJavaException javaE) throws Y;
	
	/**
	 * Handle method for objects of GenUserClass-type.
	 * 
	 * @param userclass
	 *            GenUserClass to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenUserClass userclass) throws Y;
	
	/**
	 * Handle method for objects of GenAspect-type.
	 * 
	 * @param aspect
	 *            GenAspect to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenAspect aspect) throws Y;
	
	/**
	 * Handle method for objects of GenExternalClassClass-type.
	 * 
	 * @param externalClass
	 *            GenExternalClassClass to handle.
	 * @throws Y
	 *             Y
	 */
	void handle(GenExternalClassClass externalClass) throws Y;
}
