package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;

/**
 * This visitor handles all GenTypeReference-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenTypeReferenceVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenTypeReferenceByName-type.
	 * 
	 * @param typeReferenceByName
	 *            GenTypeReferenceByName to handle.
	 * @return Value of type X
	 */
	X handle(GenTypeReferenceByName typeReferenceByName);
	
	/**
	 * Handle method for objects of GenTypeReferenceByReference-type.
	 * 
	 * @param typeReferenceByReference
	 *            GenTypeReferenceByReference to handle.
	 * @return Value of type X
	 */
	X handle(GenTypeReferenceByReference typeReferenceByReference);
	
}
