package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;

/**
 * The state of an operation indicates the level of information that the model has about the operation. E.g. whether it
 * just knows the full implementation or has a parsed operation header.
 */
public interface GenOperationState {
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	void accept(GenOperationStateVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	<X> X accept(GenOperationStateVisitorReturn<X> visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <Y>
	 *            The exception that can be thrown by the handle method.
	 * @throws Y
	 *             Throws an exception of type <X> when the handle method throws it.
	 */
	<Y extends java.lang.Exception> void accept(GenOperationStateVisitorException<Y> visitor) throws Y;
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @param <Y>
	 *            The exception that can be thrown by the handle method.
	 * @throws Y
	 *             Throws an exception of type <X> when the handle method throws it.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	<X, Y extends java.lang.Exception> X accept(GenOperationStateVisitorReturnException<X, Y> visitor) throws Y;
	
}
