package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.Generic;

/**
 * This visitor handles all GenType-types.
 */
public interface GenTypeVisitor {
	
	/**
	 * Handle method for objects of GenClass-type.
	 * 
	 * @param cla
	 *            GenClass to handle.
	 */
	void handle(GenClass cla);
	
	/**
	 * Handle method for objects of GenCollectionType-type.
	 * 
	 * @param collectionType
	 *            GenCollectionType to handle.
	 */
	void handle(GenCollectionType collectionType);
	
	/**
	 * Handle method for objects of GenPrimitiveType-type.
	 * 
	 * @param primitiveType
	 *            GenPrimitiveType to handle.
	 */
	void handle(GenPrimitiveType primitiveType);
	
	/**
	 * Handle method for objects of GenMapType-type.
	 * 
	 * @param mapType
	 *            GenMapType to handle.
	 */
	void handle(GenMapType mapType);
	
	/**
	 * Handle method for objects of GenImportType-type.
	 * 
	 * @param importType
	 *            GenImportType to handle.
	 */
	void handle(GenImportType importType);
	
	/**
	 * Handle method for objects of Generic-type.
	 * 
	 * @param generic
	 *            Generic to handle.
	 */
	void handle(Generic generic);
	
	/**
	 * Handle method for objects of GenJavaUtilCollection-type.
	 * 
	 * @param javaUtilCollection
	 *            GenJavaUtilCollection to handle.
	 */
	void handle(GenJavaUtilCollection javaUtilCollection);
	
	/**
	 * Handle method for objects of GenDummyType-type.
	 * 
	 * @param dummy
	 *            GenDummyType to handle.
	 */
	void handle(GenDummyType dummy);
	
}
