package de.fhdw.wtf.facade;

import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenQualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;

/**
 * This class contains all constants of package names, where things shall be generated.
 */
public final class PackageConstants {
	
	/**
	 * Constructor.
	 */
	private PackageConstants() {
	}
	
	/**
	 * First part of the package for generated things.
	 */
	public static final GenUnqualifiedPackage GENERATED_PACKAGE = GenUnqualifiedPackage.create("generated");
	
	/**
	 * First part of the package for aspects.
	 */
	public static final GenQualifiedPackage ASPECT_PACKAGE = GenQualifiedPackage.create(
			GENERATED_PACKAGE,
			GenUnqualifiedPackage.create("aspects"));
	
	/**
	 * First part of the package for products.
	 */
	public static final GenQualifiedPackage PRODUCT_PACKAGE = GenQualifiedPackage.create(
			GENERATED_PACKAGE,
			GenUnqualifiedPackage.create("products"));
	
	/**
	 * First part of the package for sums.
	 */
	public static final GenPackage SUM_PACKAGE = GenQualifiedPackage.create(
			GENERATED_PACKAGE,
			GenUnqualifiedPackage.create("sums"));
	
	/**
	 * First part of the package for visitors.
	 */
	public static final GenPackage VISITOR_PACKAGE = GenQualifiedPackage.create(
			GENERATED_PACKAGE,
			GenUnqualifiedPackage.create("visitors"));
	
	/**
	 * First part of the package for factories.
	 */
	public static final GenPackage FACTORY_PACKAGE = GenQualifiedPackage.create(
			GENERATED_PACKAGE,
			GenUnqualifiedPackage.create("factories"));
	
	/**
	 * First part of the package for the application.
	 */
	public static final GenPackage APPLICATION_PACKAGE = GenQualifiedPackage.create(
			GenUnqualifiedPackage.create("core"),
			GenUnqualifiedPackage.create("application"));
}
