package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorReturn;

/**
 * A GenSimpleInterfaceClass represents an java interface that shall be generated.
 */
public final class GenSimpleInterfaceClass extends GenInterfaceClass {
	
	/**
	 * Instantiates a new {@link GenSimpleInterfaceClass}.
	 * 
	 * @param name
	 *            The name of the interface.
	 * @param operations
	 *            The operations the interface has.
	 * @param implement
	 *            The interfaces this interface implements.
	 * @param packag
	 *            The package the interface is in.
	 * @param comment
	 *            The comment describing this interface.
	 * @param nonGeneratedPart
	 *            The additional part of the interface that is not generated.
	 */
	private GenSimpleInterfaceClass(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		super(name, operations, implement, packag, comment, nonGeneratedPart);
	}
	
	/**
	 * Creates a new {@link GenSimpleInterfaceClass}.
	 * 
	 * @param name
	 *            The name of the interface.
	 * @param operations
	 *            The operations the interface has.
	 * @param implement
	 *            The interfaces this interface implements.
	 * @param packag
	 *            The package the interface is in.
	 * @param comment
	 *            The comment describing this interface.
	 * @param nonGeneratedPart
	 *            The additional part of the interface that is not generated.
	 * @return {@link GenSimpleInterfaceClass}
	 */
	public static GenSimpleInterfaceClass create(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		return new GenSimpleInterfaceClass(name, operations, implement, packag, comment, nonGeneratedPart);
	}
	
	@Override
	public void accept(final GenInterfaceClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenInterfaceClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <Y extends Exception> void accept(final GenInterfaceClassVisitorException<Y> visitor) throws Y {
		visitor.handle(this);
	}
	
}
