/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.facade;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.exception.editor.CheckException;
import de.fhdw.wtf.common.exception.editor.GeneralCheckException;
import de.fhdw.wtf.common.exception.editor.MultipleCheckExceptions;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.CyclicPartDefinitionException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.GroupDependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.task.TaskExecutorFixed;
import de.fhdw.wtf.common.task.result.ExceptionalTaskResult;
import de.fhdw.wtf.common.task.result.OKTaskResult;
import de.fhdw.wtf.common.task.result.TaskResult;
import de.fhdw.wtf.common.task.result.visitor.TaskResultVisitor;
import de.fhdw.wtf.facade.SystemException;
import de.fhdw.wtf.generator.database.generation.InitialGenerator;
import de.fhdw.wtf.generator.database.tasks.AttributeGenerationTask;
import de.fhdw.wtf.generator.database.tasks.SpecializationGenerationTask;
import de.fhdw.wtf.generator.database.tasks.TypeGenerationTask;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.transformer.clipper.ClipToFileTask;
import de.fhdw.wtf.generator.transformer.clipper.ClipperConfiguration;
import de.fhdw.wtf.generator.transformer.clipper.LinkToGenClassTask;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.AppStarterTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.ConstructorSymmetricAttribute;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.DelegationTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.FactoryTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.InheritanceTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.OperationAttributeTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.SuperGenerationTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.TypeTransformer;
import de.fhdw.wtf.generator.transformer.visitorTransformation.VisitorTypeTransformer;
import de.fhdw.wtf.generator.writer.tasks.FileWriterTask;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.OracleDataBasePreparator;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.facade.OracleObjectFacadeImplementation;
import de.fhdw.wtf.persistence.utils.PropertiesReader;
import de.fhdw.wtf.persistence.utils.PropertiesReaderFile;
import de.fhdw.wtf.tooling.SyntaxCheckAbstract;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;

public final class ModelManager
extends SyntaxCheckAbstract {
    private static ModelManager instance;

    public static synchronized ModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManager();
        }
        return instance;
    }

    private ModelManager() {
    }

    public GeneratorModel generateJava(Model referencedModel, String modelRootDirectory) throws MultipleCheckExceptions {
        ClipperConfiguration configurationClip = new ClipperConfiguration(modelRootDirectory + "clipper/generated/model", modelRootDirectory + "/generated/model");
        ClipperConfiguration configurationLink = new ClipperConfiguration(modelRootDirectory + "clipper/", modelRootDirectory);
        return this.generateJava(referencedModel, modelRootDirectory, configurationClip, configurationLink, true);
    }

    public GeneratorModel generateJava(Model referencedModel, String modelRootDirectory, ClipperConfiguration configurationClip, ClipperConfiguration configurationLink, boolean runVisitorAndFactoryGenerators) throws MultipleCheckExceptions {
        MultipleCheckExceptions results = new MultipleCheckExceptions();
        TaskExecutorFixed exec = TaskExecutorFixed.create();
        GeneratorModel javaGeneratorModel = GeneratorModel.create();
        GroupDependencyTask transformers = new GroupDependencyTask((TaskExecutor)exec);
        try {
            TypeTransformer typeTransformer = new TypeTransformer(referencedModel, (TaskExecutor)exec, javaGeneratorModel);
            OperationAttributeTransformer operationAttributeTransformer = OperationAttributeTransformer.create(referencedModel, (TaskExecutor)exec, javaGeneratorModel, typeTransformer);
            DelegationTransformer delegationTransformer = new DelegationTransformer(referencedModel, (TaskExecutor)exec, javaGeneratorModel);
            delegationTransformer.addDependency((DependencyTask)operationAttributeTransformer);
            SuperGenerationTransformer constructorCallGenerationTask = new SuperGenerationTransformer(referencedModel, (TaskExecutor)exec, javaGeneratorModel);
            constructorCallGenerationTask.addDependency((DependencyTask)delegationTransformer);
            InheritanceTransformer inheritanceTransformer = new InheritanceTransformer(referencedModel, (TaskExecutor)exec, javaGeneratorModel, operationAttributeTransformer);
            ConstructorSymmetricAttribute constructorSymmetricAttribute = new ConstructorSymmetricAttribute(referencedModel, (TaskExecutor)exec, javaGeneratorModel);
            constructorSymmetricAttribute.addDependency((DependencyTask)constructorCallGenerationTask);
            constructorSymmetricAttribute.addDependency((DependencyTask)operationAttributeTransformer);
            transformers.addMembers(new DependencyTask[]{typeTransformer, operationAttributeTransformer, constructorCallGenerationTask, inheritanceTransformer, delegationTransformer, constructorSymmetricAttribute});
            if (runVisitorAndFactoryGenerators) {
                VisitorTypeTransformer typeVisitor = VisitorTypeTransformer.create(referencedModel, (TaskExecutor)exec, javaGeneratorModel, inheritanceTransformer);
                delegationTransformer.addDependency((DependencyTask)typeVisitor);
                AppStarterTransformer appStarterTransformer = new AppStarterTransformer((TaskExecutor)exec, javaGeneratorModel, (DependencyTask)inheritanceTransformer);
                appStarterTransformer.addDependency((DependencyTask)typeVisitor);
                FactoryTransformer factoryTransformer = new FactoryTransformer((TaskExecutor)exec, javaGeneratorModel, (DependencyTask)inheritanceTransformer);
                factoryTransformer.addDependency(appStarterTransformer);
                transformers.addMembers(new DependencyTask[]{typeVisitor, appStarterTransformer, factoryTransformer});
            }
        }
        catch (CyclicDependencyException | CyclicPartDefinitionException e) {
            throw new SystemException(e);
        }
        GroupDependencyTask clipper = new GroupDependencyTask((TaskExecutor)exec);
        ClipToFileTask clipperImport = new ClipToFileTask((TaskExecutor)exec, configurationClip);
        LinkToGenClassTask methodInsertion = new LinkToGenClassTask((TaskExecutor)exec, javaGeneratorModel, configurationLink, clipperImport);
        try {
            clipper.addMembers(new DependencyTask[]{clipperImport, methodInsertion});
            clipper.addDependency((DependencyTask)transformers);
        }
        catch (CyclicDependencyException | CyclicPartDefinitionException e) {
            throw new SystemException(e);
        }
        if (modelRootDirectory != null) {
            new FileWriterTask((TaskExecutor)exec, javaGeneratorModel, modelRootDirectory, (DependencyTask)clipper);
        }
        try {
            exec.startAllKnownTasks();
            Collection resultTasks = exec.getResultsAndShutdown();
            this.addsExceptionalTasksToMultipleExceptions(results, resultTasks);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SystemException(e);
        }
        if (!results.isEmpty()) {
            throw results;
        }
        return javaGeneratorModel;
    }

    public void generatePersistence(Model model, GeneratorModel genModel, String dbPropertiesPath) throws MultipleCheckExceptions {
        MultipleCheckExceptions results = new MultipleCheckExceptions();
        try {
            this.prepareDatabase(dbPropertiesPath);
            InitialGenerator generator = new InitialGenerator();
            TaskExecutorFixed taskManager = TaskExecutorFixed.create();
            TypeGenerationTask typeGenerationTask = new TypeGenerationTask(model, genModel, (TaskExecutor)taskManager, generator);
            AttributeGenerationTask attributeGenerationTask = new AttributeGenerationTask(model, (TaskExecutor)taskManager, generator);
            SpecializationGenerationTask specializationGenerationTask = new SpecializationGenerationTask(model, (TaskExecutor)taskManager, generator);
            attributeGenerationTask.addDependency((DependencyTask)typeGenerationTask);
            specializationGenerationTask.addDependency((DependencyTask)typeGenerationTask);
            taskManager.startAllKnownTasks();
            Collection resultTasks = taskManager.getResultsAndShutdown();
            this.addsExceptionalTasksToMultipleExceptions(results, resultTasks);
        }
        catch (PersistenceException e) {
            results.add((CheckException)new GeneralCheckException((Exception)((Object)e)));
        }
        catch (CyclicDependencyException | IOException | InterruptedException | ExecutionException e) {
            throw new SystemException(e);
        }
        if (!results.isEmpty()) {
            throw results;
        }
    }

    private void addsExceptionalTasksToMultipleExceptions(final MultipleCheckExceptions list, Collection<TaskResult> taskresults) {
        for (TaskResult taskResult : taskresults) {
            taskResult.accept(new TaskResultVisitor(){

                public void handleOkTaskResult(OKTaskResult result) {
                }

                public void handleExceptionalTaskResult(ExceptionalTaskResult result) {
                    list.add((CheckException)new GeneralCheckException(result.getError()));
                }
            });
        }
    }

    private void prepareDatabase(String propertiesPath) throws IOException, PersistenceException {
        OracleDatabaseManager oracleDatabaseManager = OracleDatabaseManager.getInstance();
        PropertiesReaderFile prop = new PropertiesReaderFile();
        prop.initialize(propertiesPath);
        oracleDatabaseManager.setConnectionConstantsFromFile((PropertiesReader)prop);
        oracleDatabaseManager.connect();
        OracleDataBasePreparator preparator = new OracleDataBasePreparator();
        if (!preparator.isTableStructureValid()) {
            preparator.dropWholeSchema();
            preparator.createWholeSchema();
        }
        if (!preparator.areProceduresCreated()) {
            preparator.createProcedures();
        }
        new OracleObjectFacadeImplementation(oracleDatabaseManager, null).clear();
        oracleDatabaseManager.getClassFacade().clear();
    }
}

