/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.database.generation;

import de.fhdw.wtf.generator.database.exception.GenerationException;
import de.fhdw.wtf.generator.database.exception.NotSameAttributeException;
import de.fhdw.wtf.persistence.exception.NoSubtypeException;
import de.fhdw.wtf.persistence.exception.NotAbstractException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RefactoringsGenerator {
    private final ClassFacade classFacade;
    private final ObjectFacade objectFacade;

    public RefactoringsGenerator(ClassFacade classFacade, ObjectFacade objectFacade) {
        this.classFacade = classFacade;
        this.objectFacade = objectFacade;
    }

    public void pushDown(UnidirectionalAssociation association, Collection<UserType> subtypes) throws PersistenceException, NoSubtypeException, NotAbstractException, NotSameAttributeException {
        this.checkAreSubTypesOf(subtypes, association.getOwner());
        if (!association.getOwner().isAbs()) {
            throw new NotAbstractException();
        }
        Collection<Long> newAssociations = this.createUnidirectionalAssociationsForAllSubtypes(subtypes, association);
        this.classFacade.updateLinksToNewAssociation(Long.valueOf(association.getId()), newAssociations);
        this.classFacade.deleteAssociation(Long.valueOf(association.getId()));
    }

    private void checkAreSubTypesOf(Collection<UserType> subtypes, UserType superType) throws NotSameAttributeException, PersistenceException {
        for (UserType current : subtypes) {
            this.checkIsSuperTypeOf((Type)current, superType);
        }
    }

    private Collection<Long> createUnidirectionalAssociationsForAllSubtypes(Collection<UserType> subtypes, UnidirectionalAssociation template) throws PersistenceException {
        if (subtypes.isEmpty()) {
            throw new NoSubtypeException();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (UserType current : subtypes) {
            UnidirectionalAssociation create = this.classFacade.createUnidirectionalAssociation(template.getName(), template.isEssential(), template.isUnique(), current, template.getTarget());
            result.add(create.getId());
        }
        return result;
    }

    public void expandUnidirectionalAssociationTarget(UnidirectionalAssociation asso, UserType newType) throws PersistenceException, NotSameAttributeException {
        this.checkIsSuperTypeOf(asso.getTarget(), newType);
        UnidirectionalAssociation newAsso = this.classFacade.createUnidirectionalAssociation(asso.getName(), asso.isEssential(), asso.isUnique(), asso.getOwner(), (Type)newType);
        ArrayList<Long> newAssociations = new ArrayList<Long>();
        newAssociations.add(newAsso.getId());
        this.classFacade.updateLinksToNewAssociation(Long.valueOf(asso.getId()), newAssociations);
        this.classFacade.deleteAssociation(Long.valueOf(asso.getId()));
    }

    public void pullUp(Collection<UnidirectionalAssociation> asso, UserType supertype) throws PersistenceException, NotSameAttributeException, GenerationException {
        if (asso.isEmpty()) {
            throw new GenerationException("You must specify associations!"){
                private static final long serialVersionUID = 1L;
            };
        }
        this.checkIsSuperTypeOfOwners(asso, supertype);
        boolean essential = this.checkEssential(asso);
        boolean unique = this.checkUnique(asso);
        Type target = this.checkSameTarget(asso);
        String name = this.checkName(asso);
        UnidirectionalAssociation newAsso = this.classFacade.createUnidirectionalAssociation(name, essential, unique, supertype, target);
        ArrayList<Long> newAssociation = new ArrayList<Long>();
        newAssociation.add(newAsso.getId());
        for (UnidirectionalAssociation current : asso) {
            this.classFacade.updateLinksToNewAssociation(Long.valueOf(current.getId()), newAssociation);
            this.classFacade.deleteAssociation(Long.valueOf(current.getId()));
        }
    }

    private void checkIsSuperTypeOfOwners(Collection<UnidirectionalAssociation> asso, UserType supertype) throws NotSameAttributeException, PersistenceException {
        for (UnidirectionalAssociation current : asso) {
            this.checkIsSuperTypeOf((Type)current.getOwner(), supertype);
        }
    }

    private void checkIsSuperTypeOf(Type subtype, UserType superType) throws NotSameAttributeException, PersistenceException {
        if (!this.classFacade.isSuperClassTo((Type)superType, subtype)) {
            throw new NotSameAttributeException("supertype");
        }
    }

    private Type checkSameTarget(Collection<UnidirectionalAssociation> asso) throws NotSameAttributeException {
        Iterator<UnidirectionalAssociation> i = asso.iterator();
        Type result = i.next().getTarget();
        while (i.hasNext()) {
            UnidirectionalAssociation current = i.next();
            if (current.getTarget().equals(result)) continue;
            throw new NotSameAttributeException("target");
        }
        return result;
    }

    private UserType checkSameOwner(Collection<UnidirectionalAssociation> asso) throws NotSameAttributeException {
        Iterator<UnidirectionalAssociation> i = asso.iterator();
        UserType result = i.next().getOwner();
        while (i.hasNext()) {
            UnidirectionalAssociation current = i.next();
            if (current.getOwner().equals(result)) continue;
            throw new NotSameAttributeException("owner");
        }
        return result;
    }

    private boolean checkUnique(Collection<UnidirectionalAssociation> asso) throws NotSameAttributeException {
        Iterator<UnidirectionalAssociation> i = asso.iterator();
        boolean result = i.next().isUnique();
        while (i.hasNext()) {
            UnidirectionalAssociation current = i.next();
            if (!current.isUnique() != result) continue;
            throw new NotSameAttributeException("unique");
        }
        return result;
    }

    private Boolean checkEssential(Collection<UnidirectionalAssociation> asso) throws NotSameAttributeException {
        Iterator<UnidirectionalAssociation> i = asso.iterator();
        boolean result = i.next().isEssential();
        while (i.hasNext()) {
            UnidirectionalAssociation current = i.next();
            if (!current.isEssential() != result) continue;
            throw new NotSameAttributeException("essential");
        }
        return result;
    }

    private String checkName(Collection<UnidirectionalAssociation> asso) throws NotSameAttributeException {
        Iterator<UnidirectionalAssociation> i = asso.iterator();
        String result = i.next().getName();
        while (i.hasNext()) {
            UnidirectionalAssociation current = i.next();
            if (current.getName().equals(result)) continue;
            throw new NotSameAttributeException("Name");
        }
        return result;
    }

    public void deleteUserType(UserType type, Collection<UnidirectionalAssociation> ownedAssociations, Collection<UserType> subtypes) throws PersistenceException, NotSameAttributeException {
        if (!type.isAbs()) {
            throw new NotAbstractException();
        }
        for (UnidirectionalAssociation current : ownedAssociations) {
            this.pushDown(current, subtypes);
        }
        this.classFacade.deleteUserType(Long.valueOf(type.getId()));
    }

    public UserType insertUserTypeBetween(UserType lowerType, UserType upperType, String name) throws NotSameAttributeException, PersistenceException {
        this.checkIsSuperTypeOf((Type)lowerType, upperType);
        UserType newType = this.classFacade.createUserType(name, true, false);
        this.classFacade.createSpecializationBetween(newType, (Type)lowerType);
        this.classFacade.createSpecializationBetween(upperType, (Type)newType);
        this.classFacade.finalizeSpecialization();
        return newType;
    }

    public void extractClassFromUnidirectionalAssociations(List<UnidirectionalAssociation> assoOld, String typeName) throws NotSameAttributeException, PersistenceException {
        UserType from = this.checkSameOwner(assoOld);
        UserType newType = this.classFacade.createUserType(typeName, false, false);
        UnidirectionalAssociation newAsso = this.classFacade.createUnidirectionalAssociation("my" + typeName, true, true, from, (Type)newType);
        List<UnidirectionalAssociation> newAssos = this.createUnidirectionalAssociationCopiesWithNewOwner(assoOld, newType);
        this.classFacade.moveLinksAndCreateObjects(this.getIds(assoOld), (Association)newAsso, newType, this.getIds(newAssos));
        this.deleteUnidirectionalAssociations(assoOld);
    }

    private List<Long> getIds(List<UnidirectionalAssociation> assoOld) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (UnidirectionalAssociation current : assoOld) {
            result.add(current.getId());
        }
        return result;
    }

    private void deleteUnidirectionalAssociations(Collection<UnidirectionalAssociation> assoOld) throws PersistenceException {
        for (UnidirectionalAssociation current : assoOld) {
            this.classFacade.deleteAssociation(Long.valueOf(current.getId()));
        }
    }

    private List<UnidirectionalAssociation> createUnidirectionalAssociationCopiesWithNewOwner(Collection<UnidirectionalAssociation> assoOld, UserType newType) throws PersistenceException {
        ArrayList<UnidirectionalAssociation> result = new ArrayList<UnidirectionalAssociation>();
        for (UnidirectionalAssociation current : assoOld) {
            UnidirectionalAssociation copy = this.classFacade.createUnidirectionalAssociation(current.getName(), current.isEssential(), current.isUnique(), newType, current.getTarget());
            result.add(copy);
        }
        return result;
    }

    public ClassFacade getClassFacade() {
        return this.classFacade;
    }

    public ObjectFacade getObjectFacade() {
        return this.objectFacade;
    }
}

