package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitorReturn;

/**
 * A type reference describes the different levels of information about a type. The pointing type may only know the name
 * or the original type object.
 * 
 */
public interface GenTypeReference {
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	void accept(GenTypeReferenceVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	<X> X accept(GenTypeReferenceVisitorReturn<X> visitor);
	
	/**
	 * Returns the name of the referenced Type.
	 * 
	 * @return String
	 */
	String getName();
	
	/**
	 * Returns the fully qualified name of the referenced Type.
	 * 
	 * @return String
	 */
	String getFullyQualifiedName();
	
	/**
	 * Returns the fully qualified name of the referenced Type with generic type arguments (if any).
	 * 
	 * @return String
	 */
	String getFullyQualifiedNameWithGenericArguments();
}
