package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenAttributeVisitorReturn;

public abstract class GenAttribute extends GenClassMember {
	
	private GenTypeReference typ;
	private GenVisibility visibility;
	
	public void setTyp(final GenTypeReference typ) {
		this.typ = typ;
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenAttributeVisitorReturn<X> visitor);
	
	private final Collection<GenAttributeModifier> modifiers;
	
	protected GenAttribute(final String name,
			final GenVisibility visibility,
			final GenTypeReference typ,
			final Collection<GenAttributeModifier> modifiers) {
		super(name);
		this.typ = typ;
		this.modifiers = modifiers;
		this.setVisibility(visibility);
	}
	
	/**
	 * Projections.
	 * 
	 * @return type reference
	 */
	public GenTypeReference getTyp() {
		return this.typ;
	}
	
	public Collection<GenAttributeModifier> getModifiers() {
		return this.modifiers;
	}
	
	public GenVisibility getVisibility() {
		return this.visibility;
	}
	
	public void setVisibility(final GenVisibility visibility) {
		this.visibility = visibility;
	}
	
	public void setTyp(final de.fhdw.wtf.generator.java.generatorModel.GenType type) {
		this.typ = GenTypeReferenceByReference.create(type);
	}
	
}
