package de.fhdw.wtf.generator.database.tasks;

import java.io.IOException;

import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.task.result.ExceptionalTaskResult;
import de.fhdw.wtf.common.task.result.OKTaskResult;
import de.fhdw.wtf.common.task.result.TaskResult;
import de.fhdw.wtf.persistence.facade.IDManager;

public class WriteDatabaseIDFileTask extends DependencyTask {
	
	private static final String ASSO_FILE = "src/test/files/gen/assoIds";
	private static final String TYPE_FILE = "src/test/files/gen/typeIds";
	
	public WriteDatabaseIDFileTask(final TaskExecutor tm) {
		super(tm);
	}
	
	@Override
	public boolean containsTransitive(final DependencyTask a) {
		return false;
	}
	
	@Override
	public TaskResult doWork() {
		try {
			IDManager.instance().persistIDRelationsToFile(TYPE_FILE, ASSO_FILE);
		} catch (final IOException e) {
			return new ExceptionalTaskResult(e);
		}
		return new OKTaskResult();
	}
	
}
