package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerationModelItemVisitor;

public final class GenAdvice extends GenerationModelItem {
	
	private final GenJoinpoint joinpoint;
	private final String methodBody;
	
	private GenAdvice(final String name, final GenJoinpoint joinpoint, final String methodBody) {
		super(name);
		this.joinpoint = joinpoint;
		this.methodBody = methodBody;
	}
	
	public static GenAdvice create(final String name, final GenJoinpoint joinpoint, final String methodBody) {
		return new GenAdvice(name, joinpoint, methodBody);
	}
	
	@Override
	public void accept(final GenerationModelItemVisitor visitor) {
		visitor.handle(this);
	}
	
	public GenJoinpoint getJoinpoint() {
		return this.joinpoint;
	}
	
	public String getMethodBody() {
		return this.methodBody;
	}
	
}
