package de.fhdw.wtf.generator.java.generatorModel;

/**
 * A GenParameterModifier represents one of all possible modifiers for java-parameters. For example "final".
 */
public enum GenParameterModifier {
	/**
	 * The {@link GenParameterModifier} "final" declares that the value of a variable ones initialized can not be
	 * changed anymore.
	 */
	FINAL("final");
	
	/**
	 * The String-representation of this {@link GenParameterModifier}.
	 */
	private final String t;
	
	/**
	 * Instantiates a new {@link GenParameterModifier}.
	 * 
	 * @param t
	 *            The String-representation of the GenParameterModifier.
	 */
	GenParameterModifier(final String t) {
		this.t = t;
	}
	
	@Override
	public String toString() {
		return this.t;
	}
}
