package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitorReturn;

/**
 * A class that represents the "String"-type known from Java in the generation process.
 */
public final class GenStringType extends GenPrimitiveType {
	
	/**
	 * The one instance of this type.
	 */
	private static GenStringType instance = null;
	/**
	 * The corresponding class in wtf-sources for this type.
	 */
	private static GenStringClass correspondingClass = null;
	
	/**
	 * Instantiates a new GenStringType.
	 */
	private GenStringType() {
		super(STRING_TYPE_NAME);
	}
	
	/**
	 * The name of this type.
	 */
	private static final java.lang.String STRING_TYPE_NAME = "Str";
	
	/**
	 * Returns the one existing instance of this type.
	 * 
	 * @return GenStringType
	 */
	public static synchronized GenStringType getInstance() {
		if (instance == null) {
			instance = new GenStringType();
		}
		return instance;
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return BASE_PACKAGE + this.getName();
	}
	
	/**
	 * Returns the one instance of the corresponding class in wtf-sources for this type.
	 * 
	 * @return GenStringClass
	 */
	public static synchronized GenStringClass getCorrespondingClass() {
		if (correspondingClass == null) {
			correspondingClass = GenStringClass.getInstance();
		}
		return GenStringType.correspondingClass;
	}
	
	@Override
	public void accept(final GenPrimitiveTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenPrimitiveTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
