package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenMutableList;
import de.fhdw.wtf.generator.java.generatorModel.GenMutableMap;

/**
 * This visitor handles all GenCollectionType-types.
 */
public interface GenCollectionTypeVisitor {
	
	/**
	 * Handle method for objects of GenMutableList-type.
	 *
	 * @param list
	 *            GenMutableList to handle.
	 */
	void handle(GenMutableList list);
	
	/**
	 * Handle method for objects of GenMutableMap-type.
	 *
	 * @param map
	 *            GenMutableMap to handle.
	 */
	void handle(GenMutableMap map);
	
}
