package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;

/**
 * This visitor handles all GenInterfaceClass-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenInterfaceClassVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenSimpleInterfaceClass-type.
	 * 
	 * @param simpleInterface
	 *            GenSimpleInterfaceClass to handle.
	 * @return Value of type X
	 */
	X handle(GenSimpleInterfaceClass simpleInterface);
	
	/**
	 * Handle method for objects of GenInterfaceWithClassImplClass-type.
	 * 
	 * @param interfaceWithImplClass
	 *            GenInterfaceWithClassImplClass to handle.
	 * @return Value of type X
	 */
	X handle(GenInterfaceWithClassImplClass interfaceWithImplClass);
	
	/**
	 * Handle method for objects of GenExternalInterfaceClass-type.
	 * 
	 * @param iface
	 *            GenExternalInterfaceClass to handle.
	 * @return Value of type X.
	 */
	X handle(GenExternalInterfaceClass iface);
}
