package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;

/**
 * This visitor handles all GenTypeReference-types.
 */
public interface GenTypeReferenceVisitor {
	
	/**
	 * Handle method for objects of GenTypeReferenceByName-type.
	 * 
	 * @param typeReferenceByName
	 *            GenTypeReferenceByName to handle.
	 */
	void handle(GenTypeReferenceByName typeReferenceByName);
	
	/**
	 * Handle method for objects of GenTypeReferenceByReference-type.
	 * 
	 * @param typeReferenceByReference
	 *            GenTypeReferenceByReference to handle.
	 */
	void handle(GenTypeReferenceByReference typeReferenceByReference);
	
}
