package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenerateAsClassState;
import de.fhdw.wtf.generator.java.generatorModel.GenerateAsInterfaceWithImplState;

/**
 * This visitor handles all GenerateAsState-types.
 */
public interface GenerateAsStateVisitor {
	
	/**
	 * Handle method for objects of GenerateAsClassState-type.
	 * 
	 * @param asClassState
	 *            GenerateAsClassState to handle.
	 */
	void handle(GenerateAsClassState asClassState);
	
	/**
	 * Handle method for objects of GenerateAsInterfaceWithImplState-type.
	 * 
	 * @param asInterfaceState
	 *            GenerateAsInterfaceWithImplState to handle.
	 */
	void handle(GenerateAsInterfaceWithImplState asInterfaceState);
}
