package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenerateAsClassState;
import de.fhdw.wtf.generator.java.generatorModel.GenerateAsInterfaceWithImplState;

/**
 * This visitor handles all GenerateAsState-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenerateAsStateVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenerateAsClassState-type.
	 * 
	 * @param asClassState
	 *            GenerateAsClassState to handle.
	 * @return Value of type X
	 */
	X handle(GenerateAsClassState asClassState);
	
	/**
	 * Handle method for objects of GenerateAsInterfaceWithImplState-type.
	 * 
	 * @param asInterfaceState
	 *            GenerateAsInterfaceWithImplState to handle.
	 * @return Value of type X
	 */
	X handle(GenerateAsInterfaceWithImplState asInterfaceState);
}
