package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;

/**
 * This visitor handles all GenericTypeState-types.
 */
public interface GenericTypeStateVisitor {
	
	/**
	 * Handle method for objects of GenHasGenericType-type.
	 * 
	 * @param hasType
	 *            GenHasGenericType to handle.
	 */
	void handle(GenHasGenericType hasType);
	
	/**
	 * Handle method for objects of GenHasNoGenericType-type.
	 * 
	 * @param hasNoType
	 *            GenHasNoGenericType to handle.
	 */
	void handle(GenHasNoGenericType hasNoType);
	
}
