package de.fhdw.wtf.generator.writer.writer;

import java.io.File;

import org.apache.velocity.context.Context;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;

/**
 * Used to write java interfaces from the {@link de.fhdw.wtf.generator.java.generatorModel.GeneratorModel}.
 */
public class JavaInterfaceClassFileWriter extends ClassFileWriter {
	
	private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/modelinterface.vm";
	
	public JavaInterfaceClassFileWriter(final boolean fullyQualified) {
		super(TEMPLATE_FILE_NAME, fullyQualified);
	}
	
	/**
	 * Writes the given {@link GenInterfaceClass} to the given rootDir.<br>
	 * <code>If the interfaceClass package is common and its name is Utils it will be written to: <br>
	 * /rootDir/common/Utils.java</code>
	 * 
	 * @param interfaceClass
	 * @param rootDir
	 */
	public void writeInterfaceClass(final GenInterfaceClass interfaceClass, final File rootDir) {
		this.writeClass(interfaceClass);
		this.setUpContext(interfaceClass, this.getCurrentContext());
		this.writeToFile(interfaceClass, rootDir);
	}
	
	private void setUpContext(final GenInterfaceClass c, final Context currentContext) {
		this.setOperations(c, currentContext);
	}
	
	private void setOperations(final GenInterfaceClass c, final Context currentContext) {
		currentContext.put(PARSED_OPERATIONS_KEY, this.getParsedOperations(c.getOperations()));
		currentContext.put(SIMPLE_OPERATIONS_KEY, this.getSimpleOperations(c.getOperations()));
	}
	
	@Override
	public String getStringContent(final GenClass c) {
		final GenInterfaceClass cAsGenInterfaceClass = (GenInterfaceClass) c;
		this.writeClass(cAsGenInterfaceClass);
		this.setUpContext(cAsGenInterfaceClass, this.getCurrentContext());
		return this.writeToString();
	}
	
}
