package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;

/**
 * This visitor handles all GenOperationState-types. Maybe throws an exception.
 * 
 * @param <Y>
 *            The type of exception that can be thrown by handle-methods.
 */
public interface GenOperationStateVisitorException<Y extends java.lang.Exception> {
	
	/**
	 * Handle method for objects of GenSimpleOperationState-type.
	 * 
	 * @param s
	 *            GenSimpleOperationState to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenSimpleOperationState s) throws Y;
	
	/**
	 * Handle method for objects of GenFullParsedOperationState-type.
	 * 
	 * @param s
	 *            GenFullParsedOperationState to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenFullParsedOperationState s) throws Y;
	
}
