package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;

/**
 * This visitor handles all GenInterfaceClass-types. Maybe throws an exception.
 * 
 * @param <Y>
 *            The type of exception that can be thrown by handle-methods.
 */
public interface GenInterfaceClassVisitorException<Y extends java.lang.Exception> {
	
	/**
	 * Handle method for objects of GenSimpleInterfaceClass-type.
	 * 
	 * @param simpleInterface
	 *            GenSimpleInterfaceClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenSimpleInterfaceClass simpleInterface) throws Y;
	
	/**
	 * Handle method for objects of GenInterfaceWithClassImplClass-type.
	 * 
	 * @param interfaceWithImplClass
	 *            GenInterfaceWithClassImplClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws Y;
	
	/**
	 * Handle method for objects of GenExternalInterfaceClass-type.
	 * 
	 * @param iface
	 *            GenExternalInterfaceClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenExternalInterfaceClass iface) throws Y;
}
