package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenericTypeStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenericTypeStateVisitorReturn;

/**
 * Instances of this class represents two different states regarding Generics. Generics either have the state
 * "GenHasGenericType" or "GenHasNoGenericType".
 */
public abstract class GenericTypeState {
	
	/**
	 * Constructor for GenericTypeState. Instances of this class represents two different states regarding Generics.
	 * Generics either have the state "GenHasGenericType" or "GenHasNoGenericType".
	 */
	protected GenericTypeState() {
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(GenericTypeStateVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenericTypeStateVisitorReturn<X> visitor);
	
}
