/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.AttributeModifier;
import de.fhdw.wtf.common.ast.AttributeModifierFindable;
import de.fhdw.wtf.common.ast.AttributeModifierMutable;
import de.fhdw.wtf.common.ast.AttributeModifierPrior;
import de.fhdw.wtf.common.ast.AttributeModifierSymmetric;
import de.fhdw.wtf.common.ast.AttributeModifierTransient;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.Operation;
import de.fhdw.wtf.common.ast.OperationModifier;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductElementType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.AttributModifierVisitor;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.OperationModifierVisitor;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAttributeModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.exception.NoAttributeAllowedInInterface;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.TypeTransformer;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.UtilTransformer;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class OperationAttributeTransformer
extends SimpleWalkerTaskForTypes {
    private final GeneratorModel generatorModel;
    private static final String DEFAULT_METHOD = "//TODO implement";
    public static final String LOAD_CONSTRUCTOR_PARAM_NAME = "userObject";
    public static final String LOAD_CONSTRUCTOR_PARAM_TYPE = "de.fhdw.wtf.persistence.meta.UserObject";
    private static final String DEFAULT_LOAD_CONSTRUCTOR = "super(userObject);";
    private static final String DEFAULT_OPERATION_COMMENT = "/** \n \t * TODO Comment Op \n\t */";
    private static final String DEFAULT_LOAD_CONSTRUCTOR_COMMENT = "/** \n \t * Loads object from database.\n \t * @param userObject The underlying user object.\n\t */";
    private static final char JAVA_LINE_END = ';';
    private static final String DEFAULT_PRODUCT_CONSTRUCTOR_COMMENT = "Create a anonym product.";
    private static final String EQUAL_SYMBOL = "=";
    private static final String THIS_POINT = "this.";
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\n";

    private OperationAttributeTransformer(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel, TypeTransformer typeTransformer) {
        super(m, taskmanager, true);
        this.generatorModel = generatorModel;
        try {
            this.addDependency((DependencyTask)typeTransformer);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in OperationAttributeTransformer.");
        }
    }

    public static OperationAttributeTransformer create(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel, TypeTransformer typeTransformer) {
        return new OperationAttributeTransformer(m, taskmanager, generatorModel, typeTransformer);
    }

    public GeneratorModel getGeneratorModel() {
        return this.generatorModel;
    }

    public void handleType(Type c) throws TaskException {
        c.accept((TypeVisitorException)new TypeVisitorException<TaskException>(){

            public void handle(AtomicType atomicType) throws TaskException {
                atomicType.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<TaskException>(){

                    public void handle(BaseType baseType) {
                    }

                    public void handle(ClassType clazz) throws TaskException {
                        for (Attribute current : clazz.getAttributes()) {
                            OperationAttributeTransformer.this.handleAttribute(current, clazz);
                        }
                        for (Operation current : clazz.getOperations()) {
                            OperationAttributeTransformer.this.handleOperation(current, clazz);
                        }
                        GenClass genOwner = OperationAttributeTransformer.this.getGeneratorModel().getClassMapping().get(clazz);
                        genOwner.accept(new GenClassVisitorException<TaskException>(){

                            @Override
                            public void handle(GenClassClass classClass) throws TaskException {
                                OperationAttributeTransformer.this.createLoadConstructor(classClass);
                            }

                            @Override
                            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                                    @Override
                                    public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                                    }

                                    @Override
                                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                                        OperationAttributeTransformer.this.createLoadConstructor(interfaceWithImplClass.getImplementor());
                                    }

                                    @Override
                                    public void handle(GenExternalInterfaceClass iface) throws TaskException {
                                    }
                                });
                            }

                            @Override
                            public void handle(GenPrimitiveClass primitiveClass) throws TaskException {
                                OperationAttributeTransformer.this.createLoadConstructor(primitiveClass.getImplementor());
                            }
                        });
                    }
                });
            }

            public void handle(CompositeType compositeType) throws TaskException {
                compositeType.accept((CompositeTypeVisitorException)new CompositeTypeVisitorException<TaskException>(){

                    public void handle(SumType sum) {
                    }

                    public void handle(ProductType product) throws TaskException {
                        GenClassClass prod = (GenClassClass)OperationAttributeTransformer.this.getGeneratorModel().getGenTypeForType((Type)product);
                        if (product.equals((Object)product.getAbstractPrototype())) {
                            OperationAttributeTransformer.this.handleProductAttributes(product, prod);
                        } else {
                            OperationAttributeTransformer.this.generateProductsGettersAndSetters(product, prod);
                        }
                        OperationAttributeTransformer.this.createLoadConstructor(prod);
                    }

                    public void handle(MapType map) {
                    }

                    public void handle(ListType list) {
                    }

                    public void handle(ThrownType thrownType) {
                    }
                });
            }

            public void handle(TypeProxy typeProxy) throws TaskException {
            }
        });
    }

    private void createLoadConstructor(GenClassClass classClass) {
        GenComment comment = GenComment.create(DEFAULT_LOAD_CONSTRUCTOR_COMMENT);
        GenClassClass returnTyp = classClass;
        String method = DEFAULT_LOAD_CONSTRUCTOR;
        Vector<GenParameter> parameters = new Vector<GenParameter>();
        parameters.add(GenParameter.create(LOAD_CONSTRUCTOR_PARAM_NAME, GenExternalClassClass.getInstance(LOAD_CONSTRUCTOR_PARAM_TYPE)));
        classClass.addConstructor(GenJavaOperation.create("", GenVisibility.PUBLIC, parameters, new Vector<GenException>(), DEFAULT_LOAD_CONSTRUCTOR, returnTyp, new Vector<GenOperationModifier>(), comment));
    }

    public void handleAttribute(Attribute a, ClassType owner) throws TaskException {
        String name = a.getName();
        GenType attrType = this.getGeneratorModel().getGenTypeForType(a.getAttrType());
        Vector<GenAttributeModifier> modifiers = this.handleAttributModifier(a, owner);
        GenJavaAttribute result = GenJavaAttribute.create(name, GenVisibility.PRIVATE, attrType, modifiers);
        this.getGeneratorModel().getClassMapping().get(owner).accept(new HandleAttributeGetOwnerGenClassVisitorException(result, a));
    }

    private Vector<GenAttributeModifier> handleAttributModifier(final Attribute a, final ClassType owner) {
        final Vector<GenAttributeModifier> modifier = new Vector<GenAttributeModifier>();
        final GenAttributeModifier finalAttr = GenAttributeModifier.FINAL;
        modifier.add(finalAttr);
        for (AttributeModifier current : a.getModifiers()) {
            current.accept(new AttributModifierVisitor(){

                public boolean handle(AttributeModifierMutable mutable) {
                    return modifier.remove((Object)finalAttr);
                }

                public boolean handle(AttributeModifierFindable findable) {
                    return true;
                }

                public boolean handle(AttributeModifierTransient tranzient) {
                    return modifier.add(GenAttributeModifier.TRANSIENT);
                }

                public boolean handle(AttributeModifierPrior prior) {
                    return true;
                }

                public boolean handle(AttributeModifierSymmetric symmetric) {
                    return OperationAttributeTransformer.this.handleSymmetricAttributeModifier(a, symmetric, owner);
                }
            });
        }
        modifier.remove((Object)finalAttr);
        return modifier;
    }

    private boolean handleSymmetricAttributeModifier(Attribute a, AttributeModifierSymmetric modifier, ClassType owner) {
        try {
            Vector<ClassType> targetClasses = this.getTargetClasses(a.getAttrType());
            for (ClassType targetClass : targetClasses) {
                this.addInverseGetterTo(a, targetClass, modifier, owner);
            }
        }
        catch (GenTypeNotReferencedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addInverseGetterTo(Attribute attribute, ClassType targetClass, AttributeModifierSymmetric modifier, ClassType owner) {
        Boolean isStarAssociation;
        String superMethodName;
        GenType returnType;
        GenClass symmetricRelationAccessClass = this.getSymmetricRelationAccessClassOfClass(owner, targetClass, attribute);
        String targetClassName = targetClass.getName().getLastAddedName().toString().toLowerCase();
        String inverseGetterIdentifier = modifier.getIdentifierToken().getIdentifier();
        String targetString = "target";
        String ownerString = "owner";
        if (attribute.getAttrType() instanceof CompositeType) {
            returnType = GenJavaUtilCollection.create(this.getGeneratorModel().getJavaClassForWTFClass((Type)owner));
            superMethodName = "inverseGetCollection";
            isStarAssociation = true;
        } else {
            returnType = this.getGeneratorModel().getJavaClassForWTFClass((Type)owner).getImplementor();
            superMethodName = "<" + returnType.getFullyQualifiedTypeNameWithGenericArguments() + ">inverseGet";
            isStarAssociation = false;
        }
        if (!isStarAssociation.booleanValue()) {
            Vector<GenParameter> parameters = new Vector<GenParameter>();
            GenParameter ownerParameter = GenParameter.create("owner", this.getGeneratorModel().getJavaClassForWTFClass((Type)owner));
            GenParameter targetParameter = GenParameter.create("target", this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass));
            parameters.add(ownerParameter);
            parameters.add(targetParameter);
            String methodContent = "//TODO methodContent wird noch implementiert";
            GenJavaOperation setMethod = GenJavaOperation.create("set" + attribute.getName(), GenVisibility.PUBLIC, parameters, new Vector<GenException>(), "//TODO methodContent wird noch implementiert", GenVoidType.getInstance(), new Vector<GenOperationModifier>(), GenComment.create(""));
            symmetricRelationAccessClass.addOperation(setMethod);
        } else {
            Vector<GenParameter> parameters1 = new Vector<GenParameter>();
            GenParameter ownerParameter1 = GenParameter.create("owner", this.getGeneratorModel().getJavaClassForWTFClass((Type)owner));
            GenParameter targetParameter1 = GenParameter.create("target", this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass));
            parameters1.add(ownerParameter1);
            parameters1.add(targetParameter1);
            String methodContentAdd = "//TODO methodContent wird noch implementiert.";
            GenJavaOperation addMethod = GenJavaOperation.create("add" + attribute.getName(), GenVisibility.PUBLIC, parameters1, new Vector<GenException>(), "//TODO methodContent wird noch implementiert.", GenVoidType.getInstance(), new Vector<GenOperationModifier>(), GenComment.create(""));
            Vector<GenParameter> parameters2 = new Vector<GenParameter>();
            GenParameter ownerParameter2 = GenParameter.create("owner", this.getGeneratorModel().getJavaClassForWTFClass((Type)owner));
            GenParameter targetParameter2 = GenParameter.create("target", this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass));
            parameters2.add(ownerParameter2);
            parameters2.add(targetParameter2);
            String methodContentRemove = "//methodContent wird noch implementiert.";
            GenJavaOperation removeMethod = GenJavaOperation.create("remove" + attribute.getName(), GenVisibility.PUBLIC, parameters2, new Vector<GenException>(), "//methodContent wird noch implementiert.", GenVoidType.getInstance(), new Vector<GenOperationModifier>(), GenComment.create(""));
            symmetricRelationAccessClass.addOperation(removeMethod);
            symmetricRelationAccessClass.addOperation(addMethod);
        }
        String associationName = "generated.model." + owner.getName().toString().replace('>', '.') + "." + attribute.getName();
        String methodContent = "return this." + superMethodName + "(" + targetClassName + ", \"" + associationName + "\");";
        GenJavaOperation inverseGetter = GenJavaOperation.create(inverseGetterIdentifier, GenVisibility.PUBLIC, new Vector<GenParameter>(), new Vector<GenException>(), methodContent, returnType, new Vector<GenOperationModifier>(), GenComment.create(""));
        GenClass genClass = this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass);
        GenClassClass genClassClass = genClass.getImplementor();
        GenParameter newParam = GenParameter.create(targetClassName, genClassClass);
        inverseGetter.getParameters().add(newParam);
        symmetricRelationAccessClass.addOperation(inverseGetter);
    }

    private Vector<ClassType> getTargetClasses(Type attrTypeOccurance) throws GenTypeNotReferencedException {
        final Vector<ClassType> targetTypes = new Vector<ClassType>();
        Type attributeType = UtilTransformer.getTypeProxyFreePrototype(attrTypeOccurance);
        attributeType.accept((TypeVisitorException)new TypeVisitorException<GenTypeNotReferencedException>(){

            public void handle(AtomicType s) throws GenTypeNotReferencedException {
                s.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<GenTypeNotReferencedException>(){

                    public void handle(BaseType baseType) throws GenTypeNotReferencedException {
                    }

                    public void handle(ClassType clazz) throws GenTypeNotReferencedException {
                        targetTypes.add(clazz);
                    }
                });
            }

            public void handle(CompositeType c) throws GenTypeNotReferencedException {
                c.accept((CompositeTypeVisitorException)new CompositeTypeVisitorException<GenTypeNotReferencedException>(){

                    public void handle(MapType map) throws GenTypeNotReferencedException {
                        targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(map.getOf()));
                    }

                    public void handle(ListType list) throws GenTypeNotReferencedException {
                        targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(list.getOf()));
                    }

                    public void handle(ProductType product) throws GenTypeNotReferencedException {
                        for (ProductElementType factorTypeOccurance : product.getElements()) {
                            targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(factorTypeOccurance.getType()));
                        }
                    }

                    public void handle(SumType sum) throws GenTypeNotReferencedException {
                        for (Type summandTypeOccurance : sum.getElements()) {
                            targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(summandTypeOccurance));
                        }
                    }

                    public void handle(ThrownType thrownType) throws GenTypeNotReferencedException {
                    }
                });
            }

            public void handle(TypeProxy s) throws GenTypeNotReferencedException {
            }
        });
        return targetTypes;
    }

    private GenClass getSymmetricRelationAccessClassOfClass(ClassType ownerClass, ClassType targetClass, Attribute attribute) {
        String ownerClassName = ownerClass.getName().getLastAddedName() + "";
        String targetClassName = targetClass.getName().getLastAddedName() + "";
        Object[] strings = new String[]{ownerClassName, targetClassName};
        Arrays.sort(strings);
        String symmetricRelationAccessName = (String)strings[0] + "_" + (String)strings[1] + "SymmetricRelationAccess";
        for (GenClass knownClass : this.getGeneratorModel().getClasses()) {
            if (!knownClass.getName().equals(symmetricRelationAccessName)) continue;
            return knownClass;
        }
        GenPackage superClassPackage = GenUnqualifiedPackage.create("de");
        superClassPackage = superClassPackage.addName("fhdw");
        superClassPackage = superClassPackage.addName("wtf");
        superClassPackage = superClassPackage.addName("context");
        superClassPackage = superClassPackage.addName("model");
        GenUserClass symmetricRelationAccessSuperClass = GenUserClass.create("SymmetricRelationAccess", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), null, superClassPackage, GenComment.createFromPlainText("", false), "");
        GenPackage classPackage = GenUnqualifiedPackage.create("generated");
        classPackage = ((GenPackage)classPackage).addName("symmetry");
        GenUserClass symmetricRelationAccessClass = GenUserClass.create(symmetricRelationAccessName, new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), symmetricRelationAccessSuperClass, classPackage, GenComment.createFromPlainText("", false), "");
        Vector<GenAttributeModifier> instanceAttributeModifiers = new Vector<GenAttributeModifier>();
        instanceAttributeModifiers.add(GenAttributeModifier.STATIC);
        GenJavaAttribute instanceAttribute = GenJavaAttribute.create("instance", GenVisibility.PRIVATE, symmetricRelationAccessClass, instanceAttributeModifiers);
        Vector<GenOperationModifier> getInstanceModifiers = new Vector<GenOperationModifier>();
        getInstanceModifiers.add(GenOperationModifier.STATIC);
        GenJavaOperation getInstanceOperation = GenJavaOperation.create("getInstance", GenVisibility.PUBLIC, new Vector<GenParameter>(), new Vector<GenException>(), "if(instance == null) instance = new " + symmetricRelationAccessName + "(); return instance;", symmetricRelationAccessClass, getInstanceModifiers, GenComment.create(""));
        Vector<String> mapLst = new Vector<String>();
        if (ownerClass.getName().equals(targetClass.getName())) {
            String newMap = this.generateHashMap(targetClass, attribute, symmetricRelationAccessClass);
            this.registerSetter(ownerClass, targetClass, attribute, symmetricRelationAccessClass);
            mapLst.add(newMap);
        } else {
            String newMap1 = this.generateHashMap(targetClass, attribute, symmetricRelationAccessClass);
            this.registerSetter(ownerClass, targetClass, attribute, symmetricRelationAccessClass);
            String newMap2 = this.generateHashMap(ownerClass, attribute, symmetricRelationAccessClass);
            this.registerSetter(targetClass, ownerClass, attribute, symmetricRelationAccessClass);
            mapLst.add(newMap1);
            mapLst.add(newMap2);
        }
        String constructorContent = "";
        for (String currentMapName : mapLst) {
            constructorContent = constructorContent + "\t\tthis." + currentMapName + " = new HashMap<>();" + System.lineSeparator();
        }
        GenJavaOperation constructor = GenJavaOperation.createConstructor(symmetricRelationAccessClass, GenVisibility.PRIVATE, new Vector<GenParameter>(), new Vector<GenException>(), constructorContent, GenComment.create(""));
        symmetricRelationAccessClass.getAttributes().add(instanceAttribute);
        symmetricRelationAccessClass.addOperation(getInstanceOperation);
        symmetricRelationAccessClass.getConstructors().add(constructor);
        this.getGeneratorModel().addNonAstClass(symmetricRelationAccessClass);
        this.getGeneratorModel().addSymmetricManager(symmetricRelationAccessClass, ownerClass);
        this.getGeneratorModel().addSymmetricManager(symmetricRelationAccessClass, targetClass);
        return symmetricRelationAccessClass;
    }

    public void handleOperation(final Operation o, ClassType owner) throws TaskException {
        GenComment comment = GenComment.create(DEFAULT_OPERATION_COMMENT);
        String name = o.getName();
        Vector<GenOperationModifier> modifiers = this.getOperationModifiers(o);
        Collection<GenException> exceptions = this.getGeneratorModel().getGenExceptionsForType(o.getReturnType());
        GenType returnTyp = this.getGeneratorModel().getGenTypeForType(o.getReturnType());
        String method = DEFAULT_METHOD + (returnTyp.getFullyQualifiedTypeName().equals("void") ? "" : "\n\t\treturn null;");
        List<GenParameter> parameters = this.handleParameter(o.getParameters());
        final GenJavaOperation result = GenJavaOperation.create(name, GenVisibility.PUBLIC, parameters, exceptions, method, returnTyp, modifiers, comment);
        GenClass genOwner = this.getGeneratorModel().getClassMapping().get(owner);
        genOwner.accept(new GenClassVisitor(){

            @Override
            public void handle(GenPrimitiveClass primitiveClass) {
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) {
                interfaceClass.accept(new GenInterfaceClassVisitor(){

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                        interfaceWithImplClass.addOperation(result);
                        interfaceWithImplClass.getClassRepresentation().addOperation(result);
                    }

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) {
                        simpleInterface.addOperation(result);
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) {
                        throw new Error("Operation " + o.getName() + " cannot be added to external interface " + iface.getFullyQualifiedTypeName());
                    }
                });
            }

            @Override
            public void handle(GenClassClass classClass) {
                classClass.addOperation(result);
            }
        });
    }

    private String generateHashMap(ClassType targetClass, Attribute attribute, GenClass symmetricRelationAccessClass) {
        String mapName = "map" + attribute.getName();
        GenParameter targetParameter00 = GenParameter.create("", this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass));
        GenJavaAttribute hashMap = GenJavaAttribute.create(mapName, GenVisibility.PRIVATE, Generic.create("java.util.HashMap<" + targetParameter00 + ", Setter>", null), new Vector<GenAttributeModifier>());
        symmetricRelationAccessClass.getImplementor().getAttributes().add(hashMap);
        return mapName;
    }

    private void registerSetter(ClassType ownerClass, ClassType targetClass, Attribute attribute, GenClass symmetricRelationAccessClass) {
        String ownerClassName = ownerClass.getName().getLastAddedName() + "";
        Vector<GenParameter> registerSetterParameters = new Vector<GenParameter>();
        GenParameter setterParameter = GenParameter.create("setter", Generic.create("Setter", null));
        GenParameter parameter = GenParameter.create(targetClass.getName().getLastAddedName() + "", this.getGeneratorModel().getJavaClassForWTFClass((Type)targetClass));
        registerSetterParameters.add(parameter);
        registerSetterParameters.add(setterParameter);
        GenJavaOperation registerSetterMethod = GenJavaOperation.create("registerSetter" + ownerClassName, GenVisibility.PUBLIC, registerSetterParameters, new Vector<GenException>(), "this.map" + attribute.getName() + ".put(" + targetClass.getName().getLastAddedName() + ",setter);", GenVoidType.getInstance(), new Vector<GenOperationModifier>(), GenComment.create(""));
        symmetricRelationAccessClass.addOperation(registerSetterMethod);
    }

    private Vector<GenOperationModifier> getOperationModifiers(Operation o) {
        final Vector<GenOperationModifier> result = new Vector<GenOperationModifier>();
        for (OperationModifier current : o.getModifiers()) {
            current.accept(new OperationModifierVisitor(){

                public boolean handle(OperationModifier abstract1) {
                    result.add(GenOperationModifier.ABSTRACT);
                    return false;
                }
            });
        }
        return result;
    }

    protected List<GenParameter> handleParameter(ProductType o) throws TaskException {
        List elements = o.getElements();
        Vector<GenParameter> result = new Vector<GenParameter>();
        for (ProductElementType productElement : elements) {
            GenType paramType = this.getGeneratorModel().getGenTypeForType(productElement.getType());
            result.add(GenParameter.create(productElement.getName(), paramType));
        }
        return result;
    }

    private void handleProductAttributes(ProductType product, GenClassClass prod) throws TaskException {
        StringBuilder methodString = new StringBuilder();
        Vector<GenParameter> parameters = new Vector<GenParameter>();
        for (ProductElementType element : product.getElements()) {
            Vector<GenAttributeModifier> modifiers = new Vector<GenAttributeModifier>();
            GenType type = this.getGeneratorModel().getGenTypeForType(element.getType());
            GenJavaAttribute currentAttr = GenJavaAttribute.create(element.getName(), GenVisibility.PROTECTED, type, modifiers);
            prod.getAttributes().add(currentAttr);
            String methodStringInitialize = THIS_POINT + currentAttr.getName() + EQUAL_SYMBOL + currentAttr.getName() + ';';
            if (methodString.toString().equals("")) {
                methodString.append(methodStringInitialize);
            } else {
                methodString.append("\n\t\t" + methodStringInitialize);
            }
            GenParameter parameter = GenParameter.create(currentAttr.getName(), currentAttr.getTyp());
            parameters.add(parameter);
        }
        GenComment comment = GenComment.createFromPlainText(DEFAULT_PRODUCT_CONSTRUCTOR_COMMENT, true);
        GenJavaOperation constructor = GenJavaOperation.createConstructor(prod, GenVisibility.PUBLIC, parameters, new Vector<GenException>(), methodString.toString(), comment);
        prod.getConstructors().add(constructor);
    }

    private void generateProductsGettersAndSetters(ProductType product, GenClassClass prod) throws TaskException {
        Iterator i = product.getElements().iterator();
        BigInteger currentElementCount = BigInteger.ZERO;
        while (i.hasNext()) {
            currentElementCount = currentElementCount.add(BigInteger.ONE);
            ProductElementType current = (ProductElementType)i.next();
            String name = current.getName();
            String capitalName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Vector<GenException> exceptions = new Vector<GenException>();
            GenType prodElementType = this.getGeneratorModel().getGenTypeForType(current.getType());
            Vector<GenOperationModifier> operationModifier = new Vector<GenOperationModifier>();
            ArrayList<GenParameter> paramsGetter = new ArrayList<GenParameter>();
            String implementationGetter = "return this.p$" + currentElementCount.toString() + ";";
            prod.addOperation(GenJavaOperation.create("get" + capitalName, GenVisibility.PUBLIC, paramsGetter, exceptions, implementationGetter, prodElementType, operationModifier, GenComment.createFromPlainText("", true)));
            ArrayList<GenParameter> paramsSetter = new ArrayList<GenParameter>();
            GenParameter setParam = GenParameter.create(name, prodElementType);
            paramsSetter.add(setParam);
            String implementationSetter = "this.p$" + currentElementCount.toString() + " = " + name + ";";
            prod.addOperation(GenJavaOperation.create("set" + capitalName, GenVisibility.PUBLIC, paramsSetter, exceptions, implementationSetter, GenVoidType.getInstance(), operationModifier, GenComment.createFromPlainText("", false)));
        }
    }

    public String toString() {
        return "Operation and Attribute generation";
    }

    public void beginTask() throws TaskException {
    }

    public void finalizeTask() throws TaskException {
    }

    private final class HandleAttributeGetOwnerGenClassVisitorException
    implements GenClassVisitorException<TaskException> {
        private final GenJavaAttribute result;
        private final Attribute a;

        private HandleAttributeGetOwnerGenClassVisitorException(GenJavaAttribute result, Attribute a) {
            this.result = result;
            this.a = a;
        }

        @Override
        public void handle(GenClassClass classClass) throws TaskException {
            classClass.getAttributes().add(this.result);
        }

        @Override
        public void handle(GenInterfaceClass interfaceClass) throws TaskException {
            interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                @Override
                public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                    throw NoAttributeAllowedInInterface.create();
                }

                @Override
                public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                    HandleAttributeGetOwnerGenClassVisitorException.this.handle(interfaceWithImplClass.getClassRepresentation());
                }

                @Override
                public void handle(GenExternalInterfaceClass iface) throws TaskException {
                    throw NoAttributeAllowedInInterface.create();
                }
            });
        }

        @Override
        public void handle(GenPrimitiveClass primitiveClass) throws NoAttributeAllowedInInterface {
        }
    }
}

