/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenDeclareInheritance;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.writer.writer.ClassClassFileWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.velocity.context.Context;

public class JavaAspectClassFileWriter
extends ClassClassFileWriter {
    private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/aspectclass.vm";
    private static final String DECLARE_PARENTS_IMPL_KEY = "declareParentsImpl";
    private static final String SUBTYPE_KEY = "subType";
    private static final String SUPERTYPE_KEY = "superType";

    public JavaAspectClassFileWriter(boolean fullyQualified) {
        super(TEMPLATE_FILE_NAME, fullyQualified);
    }

    public void writeAspectClass(GenAspect c, File rootdir) {
        this.writeClassClass(c);
        this.setUpContext(c, this.getCurrentContext());
        this.writeToFile(c, rootdir);
    }

    private void setUpContext(GenAspect c, Context currentContext) {
        this.setAttributes(c, currentContext);
        this.setOperations(c, currentContext);
        this.setdeclareParents(c, currentContext);
    }

    private void setdeclareParents(GenAspect c, Context currentContext) {
        Vector declares = new Vector();
        for (GenDeclareInheritance declare : c.getDeclareParents()) {
            HashMap<String, String> currentDeclare = new HashMap<String, String>();
            currentDeclare.put(SUBTYPE_KEY, this.typeToString(declare.getSubClass()));
            currentDeclare.put(SUPERTYPE_KEY, this.typeToString(declare.getSuperClass()));
            declares.add(currentDeclare);
        }
        currentContext.put(DECLARE_PARENTS_IMPL_KEY, declares);
    }

    private void setOperations(GenAspect c, Context currentContext) {
        currentContext.put("parsedOperations", this.getParsedOperations(c.getAllOperations()));
        ArrayList<GenJavaOperation> operationsWithSimple = new ArrayList<GenJavaOperation>();
        operationsWithSimple.addAll(c.getOperations());
        operationsWithSimple.addAll(c.getConstructors());
        currentContext.put("simpleOperations", this.getSimpleOperations(operationsWithSimple));
    }

    private void setAttributes(GenAspect c, Context currentContext) {
        currentContext.put("attributes", this.getAttributes(c.getAllAttributes()));
    }

    @Override
    public String getStringContent(GenClass c) {
        GenAspect cAsGenUserClass = (GenAspect)c;
        this.writeClassClass(cAsGenUserClass);
        this.setUpContext(cAsGenUserClass, this.getCurrentContext());
        return this.writeToString();
    }
}

