package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;

public final class GenMapType extends GenType {
	
	private GenType value;
	private GenType key;
	
	private static final String GEN_OPEN = "<";
	private static final String GEN_CLOSE = ">";
	private static final String COMMA = ",";
	
	public void setKey(final GenType newKey, final GenType newValue) {
		this.key = newKey;
		this.value = newValue;
	}
	
	private GenMapType(final String name, final GenType key, final GenType value) {
		super(name);
		this.key = key;
		this.value = value;
	}
	
	public static GenMapType create(final String name, final GenType key, final GenType value) {
		return new GenMapType(name, key, value);
	}
	
	/**
	 * Projections.
	 * 
	 * @return key
	 */
	public GenType getKey() {
		return this.key;
	}
	
	public void setKey(final GenType key) {
		this.key = key;
	}
	
	public GenType getValue() {
		return this.value;
	}
	
	public void setValue(final GenType value) {
		this.value = value;
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return this.getName();
	}
	
	@Override
	public String getFullyQualifiedTypeNameWithGenericArguments() {
		return this.getFullyQualifiedTypeName() + GEN_OPEN
				+ this.getKey().getFullyQualifiedTypeNameWithGenericArguments() + COMMA
				+ this.getValue().getFullyQualifiedTypeName() + GEN_CLOSE;
	}
	
	@Override
	public void accept(final GenTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
}
