package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;

public abstract class Transformer extends SimpleWalkerTask {
	
	private final GeneratorModel generatorModel;
	private final UtilTransformer utilTransformer;
	
	protected static final char WTF_PATH_SEP = '>';
	protected static final char PACKAGE_PATH_SEP = '.';
	
	public Transformer(final Model m, final TaskExecutor taskmanager, final GeneratorModel generatorModel) {
		super(m, taskmanager);
		this.generatorModel = generatorModel;
		this.utilTransformer = UtilTransformer.create(this.getGeneratorModel());
	}
	
	public GeneratorModel getGeneratorModel() {
		return this.generatorModel;
	}
	
	public UtilTransformer getUtilTransformer() {
		return this.utilTransformer;
	}
	
}
