package de.fhdw.wtf.facade;

import de.fhdw.wtf.common.ast.Name;
import de.fhdw.wtf.common.exception.walker.TaskException;

/**
 * A class that represents exception that occure when a generated name is too long.
 */
public class GeneratedNameTooLongException extends TaskException {
	
	/**
	 * Creates the message for this exception.
	 * 
	 * @param generatedName
	 *            The Name that was too long.
	 * @return The message as String that the generatedName is too long.
	 */
	private static String message(final Name generatedName) {
		return "The generated name " + generatedName.toString() + " is to long. (max. length: "
				+ TypeNameGenerator.getInstance().getMaxNameLength() + ")";
	}
	
	/**
	 * The UID for serialization.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * The Name that is too long.
	 */
	private final Name generatedName;
	
	/**
	 * Creates a new exception that contains a message that <code>generatedName</code> is too long.
	 * 
	 * @param generatedName
	 *            The Name that is too long.
	 */
	public GeneratedNameTooLongException(final Name generatedName) {
		super(message(generatedName));
		this.generatedName = generatedName;
	}
	
	/**
	 * Returns the generated name that was too long.
	 * 
	 * @return Name that was too long
	 */
	public Name getGeneratedName() {
		return this.generatedName;
	}
}
