/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;

public final class GenQualifiedPackage
extends GenPackage {
    private final GenUnqualifiedPackage first;
    private final GenPackage rest;
    private static final String JAVA_PACKAGE_SEPARATOR = ".";

    private GenQualifiedPackage(GenUnqualifiedPackage first, GenPackage rest) {
        this.first = first;
        this.rest = rest;
    }

    private GenQualifiedPackage(GenQualifiedPackage packageToCopy) {
        this.first = (GenUnqualifiedPackage)packageToCopy.getFirst().copy();
        this.rest = packageToCopy.getRest().copy();
    }

    public static GenQualifiedPackage create(GenUnqualifiedPackage first, GenPackage rest) {
        return new GenQualifiedPackage(first, rest);
    }

    @Override
    public GenPackage addName(String name) {
        return this.addPackage(GenUnqualifiedPackage.create(name));
    }

    @Override
    public String toString() {
        String result = this.getFirst().toString();
        result = result + JAVA_PACKAGE_SEPARATOR;
        result = result + this.getRest().toString();
        return result;
    }

    @Override
    public GenPackage addPackage(GenPackage packag) {
        return GenQualifiedPackage.create(this.getFirst(), this.getRest().addPackage(packag));
    }

    public GenUnqualifiedPackage getFirst() {
        return this.first;
    }

    public GenPackage getRest() {
        return this.rest;
    }

    @Override
    public GenPackage copy() {
        return new GenQualifiedPackage(this);
    }
}

