package de.fhdw.wtf.generator.java.generatorModel;

/**
 * A {@link GenPackage} can either be a {@link GenQualifiedPackage} or a {@link GenUnqualifiedPackage} and represents
 * java-packages in the generation process.
 */
public abstract class GenPackage {
	
	/**
	 * Constructor for {@link GenPackage}.
	 */
	protected GenPackage() {
	}
	
	/**
	 * Add the <code>name</code> to the given hierarchy.
	 * 
	 * @param name
	 *            The name to add to the {@link GenPackage}.
	 * @return Returns a newly created {@link GenPackage}.
	 */
	public abstract GenPackage addName(String name);
	
	@Override
	public abstract String toString();
	
	/**
	 * Add the <code>packag</code> to the current Package.
	 * 
	 * @param packag
	 *            The {@link GenPackage} to add to the {@link GenPackage}.
	 * @return Returns a newly created {@link GenPackage}.
	 */
	public abstract GenPackage addPackage(GenPackage packag);
	
	/**
	 * Returns an exact copy of this package.
	 * 
	 * @return GenPackage
	 */
	public abstract GenPackage copy();
	
}
