package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitorReturn;

/**
 * The GenUserClassGeneratedAsState decides whether a UserClass will be generated as java-class or as java-interface
 * containing a java-class called "Impl".
 * 
 * If the state ends with "GenerateAsInterfaceWithImpl" generate an interface with the name of the GenUserClass and all
 * public operations, that contains the GenUserClass as private inner class with the name "Impl".
 */
public final class GenerateAsInterfaceWithImplState extends GenerateAsState {
	
	/**
	 * Constructor of GenerateAsInterfaceWithImplState.
	 */
	public GenerateAsInterfaceWithImplState() {
		super();
	}
	
	@Override
	public void accept(final GenerateAsStateVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenerateAsStateVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
