package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;

/**
 * This visitor handles all GenClassClass-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenClassClassVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenException-type.
	 * 
	 * @param e
	 *            GenException to handle.
	 * @return Value of type X
	 */
	X handle(GenException e);
	
	/**
	 * Handle method for objects of GenAnyType-type.
	 * 
	 * @param anyType
	 *            GenAnyType to handle.
	 * @return Value of type X
	 */
	X handle(GenAnyType anyType);
	
	/**
	 * Handle method for objects of GenJavaException-type.
	 * 
	 * @param javaE
	 *            GenJavaException to handle.
	 * @return Value of type X
	 */
	X handle(GenJavaException javaE);
	
	/**
	 * Handle method for objects of GenUserClass-type.
	 * 
	 * @param userclass
	 *            GenUserClass to handle.
	 * @return Value of type X
	 */
	X handle(GenUserClass userclass);
	
	/**
	 * Handle method for objects of GenAspect-type.
	 * 
	 * @param aspect
	 *            GenAspect to handle.
	 * @return Value of type X
	 */
	X handle(GenAspect aspect);
	
	/**
	 * Handle method for objects of GenExternalClassClass-type.
	 * 
	 * @param externalClass
	 *            GenExternalClassClass to handle.
	 * @return Value of type X
	 */
	X handle(GenExternalClassClass externalClass);
	
}
