/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.writer.writer.ClassClassFileWriter;
import java.io.File;
import java.util.ArrayList;
import org.apache.velocity.context.Context;

public class ExceptionFileWriter
extends ClassClassFileWriter {
    private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/modelclass.vm";

    public ExceptionFileWriter(boolean fullyQualified) {
        super(TEMPLATE_FILE_NAME, fullyQualified);
    }

    private void setUpContext(GenException exceptionClass, Context currentContext) {
        this.setAttributes(exceptionClass, currentContext);
        this.setOperations(exceptionClass, currentContext);
    }

    private void setOperations(GenException exceptionClass, Context currentContext) {
        currentContext.put("parsedOperations", this.getParsedOperations(exceptionClass.getOperations()));
        ArrayList<GenJavaOperation> operationsWithSimple = new ArrayList<GenJavaOperation>();
        operationsWithSimple.addAll(exceptionClass.getOperations());
        operationsWithSimple.addAll(exceptionClass.getConstructors());
        currentContext.put("simpleOperations", this.getSimpleOperations(operationsWithSimple));
    }

    public void writeJavaExceptionClass(GenException exceptionClass, File rootdir) {
        this.writeClassClass(exceptionClass);
        this.setUpContext(exceptionClass, this.getCurrentContext());
        this.writeToFile(exceptionClass, rootdir);
    }

    public String writeJavaExceptionClassToString(GenException exceptionClass) {
        this.writeClassClass(exceptionClass);
        this.setUpContext(exceptionClass, this.getCurrentContext());
        return this.writeToString();
    }

    private void setAttributes(GenException exceptionClass, Context currentContext) {
        currentContext.put("attributes", this.getAttributes(exceptionClass.getAttributes()));
    }

    @Override
    public String getStringContent(GenClass clazz) {
        GenException clazzAsGenException = (GenException)clazz;
        this.writeClassClass(clazzAsGenException);
        this.setUpContext(clazzAsGenException, this.getCurrentContext());
        return this.writeToString();
    }
}

