/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturn;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenDeclareInheritance;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenIntegerType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.OperationAttributeTransformer;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;
import java.util.List;

public class InheritanceTransformer
extends SimpleWalkerTaskForTypes {
    private final GeneratorModel generatorModel;

    public InheritanceTransformer(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel, OperationAttributeTransformer operationAttributeTransformer) {
        super(m, taskmanager, true);
        this.generatorModel = generatorModel;
        try {
            this.addDependency((DependencyTask)operationAttributeTransformer);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in InheritanceTransformer.");
        }
    }

    public void handleType(Type c) throws TaskException {
        if (this.isEmptySum(c)) {
            return;
        }
        List superTypes = c.getSuperTypes();
        for (Type superType : superTypes) {
            this.createInheritance(c, superType);
        }
    }

    private boolean isEmptySum(Type c) {
        return (Boolean)c.accept((TypeVisitorReturn)new TypeVisitorReturn<Boolean>(){

            public Boolean handle(AtomicType atomicType) {
                return false;
            }

            public Boolean handle(CompositeType compositeType) {
                return (Boolean)compositeType.accept((CompositeTypeVisitorReturn)new CompositeTypeVisitorReturn<Boolean>(){

                    public Boolean handle(ListType list) {
                        return false;
                    }

                    public Boolean handle(MapType map) {
                        return false;
                    }

                    public Boolean handle(ProductType product) {
                        return false;
                    }

                    public Boolean handle(SumType sum) {
                        return Integer.valueOf(0).equals(sum.getElementsSizeWithoutThrownTypes());
                    }

                    public Boolean handle(ThrownType thrownType) {
                        return false;
                    }
                });
            }

            public Boolean handle(TypeProxy typeProxy) {
                return InheritanceTransformer.this.isEmptySum(HelperUtils.getTargetType((TypeProxy)typeProxy));
            }
        });
    }

    private void createInheritance(Type subType, Type superType) throws GenTypeNotReferencedException {
        GenType genSubType = this.generatorModel.getGenTypeForType(subType);
        final GenType genSuperType = this.generatorModel.getGenTypeForType(superType);
        genSubType.accept(new GenTypeVisitor(){

            @Override
            public void handle(GenClass genSubClass) {
                InheritanceTransformer.this.createInheritanceFromGenClass(genSubClass, genSuperType);
            }

            @Override
            public void handle(GenPrimitiveType primitiveType) {
                primitiveType.accept(new GenPrimitiveTypeVisitor(){

                    @Override
                    public void handle(GenVoidType voidType) {
                        throw new Error("Inheritance shall not be generated for GenVoidType.");
                    }

                    @Override
                    public void handle(GenStringType stringType) {
                        InheritanceTransformer.this.createInheritanceFromGenClass(GenStringType.getCorrespondingClass(), genSuperType);
                    }

                    @Override
                    public void handle(GenIntegerType integerType) {
                        InheritanceTransformer.this.createInheritanceFromGenClass(GenIntegerType.getCorrespondingClass(), genSuperType);
                    }
                });
            }

            @Override
            public void handle(GenDummyType dummy) {
                throw new Error("Inheritance shall not be generated for GenDummyType.");
            }

            @Override
            public void handle(GenJavaUtilCollection javaUtilCollection) {
                throw new Error("Inheritance shall not be generated for GenJavaUtilCollection.");
            }

            @Override
            public void handle(Generic generic) {
                throw new Error("Inheritance shall not be generated for Generic.");
            }

            @Override
            public void handle(GenImportType importType) {
                throw new Error("Inheritance shall not be generated for GenImportType.");
            }

            @Override
            public void handle(GenMapType mapType) {
            }

            @Override
            public void handle(GenCollectionType collectionType) {
            }
        });
    }

    private void createInheritanceFromGenClass(final GenClass genSubClass, GenType genSuperType) {
        genSuperType.accept(new GenTypeVisitor(){

            @Override
            public void handle(GenClass genSuperClass) {
                InheritanceTransformer.this.createInheritanceFromGenClassToGenClass(genSubClass, genSuperClass);
            }

            @Override
            public void handle(GenPrimitiveType primitiveType) {
            }

            @Override
            public void handle(GenDummyType dummy) {
                throw new Error("Inheritance shall not be generated for GenDummyType.");
            }

            @Override
            public void handle(GenJavaUtilCollection javaUtilCollection) {
                throw new Error("Inheritance shall not be generated for GenJavaUtilCollection.");
            }

            @Override
            public void handle(Generic generic) {
                throw new Error("Inheritance shall not be generated for Generic.");
            }

            @Override
            public void handle(GenImportType importType) {
                throw new Error("Inheritance shall not be generated for GenImportType.");
            }

            @Override
            public void handle(GenMapType mapType) {
                throw new Error("Inheritance shall not be generated for GenMapType.");
            }

            @Override
            public void handle(GenCollectionType collectionType) {
                throw new Error("Inheritance shall not be generated for GenCollectionType.");
            }
        });
    }

    private void createInheritanceFromGenClassToGenClass(final GenClass genSubClass, GenClass genSuperClass) {
        genSuperClass.accept(new GenClassVisitor(){

            @Override
            public void handle(final GenInterfaceClass genSuperInterfaceClass) {
                genSubClass.accept(new GenClassVisitor(){

                    @Override
                    public void handle(GenPrimitiveClass genSubPrimitiveClass) {
                        GenAspect aspectForBaseTypeExpansion = InheritanceTransformer.this.generatorModel.getAspectForType(genSubPrimitiveClass);
                        aspectForBaseTypeExpansion.addDeclareParents(GenDeclareInheritance.create(genSuperInterfaceClass, genSubPrimitiveClass));
                    }

                    @Override
                    public void handle(GenInterfaceClass genSubInterfaceClass) {
                        genSubInterfaceClass.getImplement().add(genSuperInterfaceClass);
                        genSubInterfaceClass.accept(new GenInterfaceClassVisitor(){

                            @Override
                            public void handle(GenInterfaceWithClassImplClass genSubInterfaceWithImplClass) {
                                genSuperInterfaceClass.accept(new GenInterfaceClassVisitor(){

                                    @Override
                                    public void handle(GenInterfaceWithClassImplClass genSuperIntWImplCls) {
                                    }

                                    @Override
                                    public void handle(GenSimpleInterfaceClass genSuperSimpleInterface) {
                                    }

                                    @Override
                                    public void handle(GenExternalInterfaceClass iface) {
                                    }
                                });
                            }

                            @Override
                            public void handle(GenSimpleInterfaceClass genSubSimpleInterface) {
                            }

                            @Override
                            public void handle(GenExternalInterfaceClass iface) {
                                throw new Error("Interface " + genSuperInterfaceClass.getFullyQualifiedTypeName() + " cannot be added as superinterface to external interface " + iface.getFullyQualifiedTypeName());
                            }
                        });
                    }

                    @Override
                    public void handle(final GenClassClass genSubClassClass) {
                        genSuperInterfaceClass.accept(new GenInterfaceClassVisitor(){

                            @Override
                            public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                            }

                            @Override
                            public void handle(GenSimpleInterfaceClass simpleInterface) {
                                genSubClassClass.getImplement().add(genSuperInterfaceClass);
                            }

                            @Override
                            public void handle(GenExternalInterfaceClass iface) {
                                genSubClassClass.getImplement().add(iface);
                            }
                        });
                    }
                });
            }

            @Override
            public void handle(final GenClassClass genSuperClassClass) {
                genSubClass.accept(new GenClassVisitor(){

                    @Override
                    public void handle(GenInterfaceClass genSubInterfaceClass) {
                        throw new Error("Inheritance transformation not possible! An interface can not extend a class.");
                    }

                    @Override
                    public void handle(GenClassClass genSubClassClass) {
                        genSubClassClass.setExtend(genSuperClassClass);
                    }

                    @Override
                    public void handle(GenPrimitiveClass genSubPrimitiveClass) {
                        throw new Error("Inheritance transformation not possible!An class for an primitive type can not extend a class.");
                    }
                });
            }

            @Override
            public void handle(GenPrimitiveClass genSuperPrimitiveClass) {
                throw new Error("Inheritance from classes for primitive types is not allowed!");
            }
        });
    }

    public String toString() {
        return "Inheritance generation";
    }

    public void beginTask() throws TaskException {
    }

    public void finalizeTask() throws TaskException {
    }
}

