/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.writer.writer.ClassClassFileWriter;
import java.io.File;
import java.util.ArrayList;
import org.apache.velocity.context.Context;

public class JavaClassFileWriter
extends ClassClassFileWriter {
    private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/modelclass.vm";

    public JavaClassFileWriter(boolean fullyQualified) {
        super(TEMPLATE_FILE_NAME, fullyQualified);
    }

    private void setUpContext(GenUserClass c, Context currentContext) {
        this.setAttributes(c, currentContext);
        this.setOperations(c, currentContext);
    }

    private void setOperations(GenUserClass c, Context currentContext) {
        currentContext.put("parsedOperations", this.getParsedOperations(c.getOperations()));
        ArrayList<GenJavaOperation> operationsWithSimple = new ArrayList<GenJavaOperation>();
        operationsWithSimple.addAll(c.getOperations());
        operationsWithSimple.addAll(c.getConstructors());
        currentContext.put("simpleOperations", this.getSimpleOperations(operationsWithSimple));
    }

    public void writeJavaClass(GenUserClass c, File rootdir) {
        this.writeClassClass(c);
        this.setUpContext(c, this.getCurrentContext());
        this.writeToFile(c, rootdir);
    }

    public String writeJavaClassToString(GenUserClass c) {
        this.writeClassClass(c);
        this.setUpContext(c, this.getCurrentContext());
        return this.writeToString();
    }

    private void setAttributes(GenUserClass c, Context currentContext) {
        currentContext.put("attributes", this.getAttributes(c.getAttributes()));
    }

    @Override
    public String getStringContent(GenClass c) {
        GenUserClass cAsGenUserClass = (GenUserClass)c;
        this.writeClassClass(cAsGenUserClass);
        this.setUpContext(cAsGenUserClass, this.getCurrentContext());
        return this.writeToString();
    }
}

