package de.fhdw.wtf.generator.writer.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.velocity.context.Context;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;

/**
 * File writer to generate code for {@line GenUserClass}es
 */
public class JavaClassFileWriter extends ClassClassFileWriter {
	
	public JavaClassFileWriter(final boolean fullyQualified) {
		super(TEMPLATE_FILE_NAME, fullyQualified);
	}
	
	private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/modelclass.vm";
	
	private void setUpContext(final GenUserClass c, final Context currentContext) {
		this.setAttributes(c, currentContext);
		this.setOperations(c, currentContext);
	}
	
	private void setOperations(final GenUserClass c, final Context currentContext) {
		currentContext.put(PARSED_OPERATIONS_KEY, this.getParsedOperations(c.getOperations()));
		final Collection<GenJavaOperation> operationsWithSimple = new ArrayList<>();
		operationsWithSimple.addAll(c.getOperations());
		operationsWithSimple.addAll(c.getConstructors());
		currentContext.put(SIMPLE_OPERATIONS_KEY, this.getSimpleOperations(operationsWithSimple));
	}
	
	/**
	 * Writes the file for the given {@link de.fhdw.wtf.generator.java.generatorModel.GenClass} c.
	 * 
	 * @param c
	 */
	public void writeJavaClass(final GenUserClass c, final File rootdir) {
		this.writeClassClass(c);
		this.setUpContext(c, this.getCurrentContext());
		this.writeToFile(c, rootdir);
	}
	
	/**
	 * Writes the given {@link GenUserClass} c to a String.
	 * 
	 * @param c
	 *            The class to write.
	 * @return A String representation of the GenUserClass in java-syntax.
	 */
	public String writeJavaClassToString(final GenUserClass c) {
		this.writeClassClass(c);
		this.setUpContext(c, this.getCurrentContext());
		return this.writeToString();
	}
	
	/**
	 * Sets all values for the attribute declaration of {@link de.fhdw.wtf.generator.java.generatorModel.GenClass} c to
	 * the {@link Context}.
	 * 
	 * @param c
	 * @param currentContext
	 */
	private void setAttributes(final GenUserClass c, final Context currentContext) {
		currentContext.put(ATTRIBUTES_KEY, this.getAttributes(c.getAttributes()));
	}
	
	@Override
	public String getStringContent(final GenClass c) {
		final GenUserClass cAsGenUserClass = (GenUserClass) c;
		this.writeClassClass(cAsGenUserClass);
		this.setUpContext(cAsGenUserClass, this.getCurrentContext());
		return this.writeToString();
	}
}
