/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenericTypeState;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenericTypeStateVisitorReturn;

public final class Generic
extends GenType
implements Comparable<Generic> {
    private static final String BOUND_SEPARATOR = " extends ";
    private final String name;
    private final GenericTypeState type;

    private Generic(String name, GenericTypeState type) {
        super(name);
        this.name = name;
        this.type = type;
    }

    public static Generic create(String name, GenericTypeState type) {
        return new Generic(name, type);
    }

    public String getGenericName() {
        return this.name;
    }

    public GenericTypeState getGenericType() {
        return this.type;
    }

    @Override
    public String getFullyQualifiedTypeName() {
        return this.getName();
    }

    public String getTypeName() {
        String stateName = this.type.accept(new GenericTypeStateVisitorReturn<String>(){

            @Override
            public String handle(GenHasGenericType hasType) {
                return hasType.getType().getFullyQualifiedTypeNameWithGenericArguments();
            }

            @Override
            public String handle(GenHasNoGenericType hasNoType) {
                return "";
            }
        });
        return stateName;
    }

    @Override
    public String getFullyQualifiedTypeNameWithGenericArguments() {
        return this.getFullyQualifiedTypeName();
    }

    @Override
    public void accept(GenTypeVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <X> X accept(GenTypeVisitorReturn<X> visitor) {
        return visitor.handle(this);
    }

    public <X extends Exception> void accept(GenTypeVisitorException<X> visitor) throws X {
        visitor.handle(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Generic) {
            Generic genObj = (Generic)obj;
            if (this.getFullyQualifiedTypeName().equals(genObj.getFullyQualifiedTypeName()) && this.getGenericName().equals(genObj.getGenericName()) && this.getGenericType().equals(genObj.getGenericType()) && this.getName().equals(genObj.getName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getFullyQualifiedTypeName().hashCode() ^ this.getGenericName().hashCode() ^ this.getGenericType().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public int compareTo(Generic o) {
        return this.getGenericName().compareTo(o.getGenericName());
    }

    public String toString() {
        String result = this.getName();
        result = result + this.getGenericType().accept(new GenericTypeStateVisitorReturn<String>(){

            @Override
            public String handle(GenHasGenericType hasType) {
                return Generic.BOUND_SEPARATOR + hasType.getType().getFullyQualifiedTypeName();
            }

            @Override
            public String handle(GenHasNoGenericType hasNoType) {
                return "";
            }
        });
        return result;
    }
}

