/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.ExceptionClassType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenIntegerType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.GenQualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.UtilTransformer;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class GeneratorModel {
    private final Vector<GenClass> nonASTClasses;
    private final Map<GenUserClass, Vector<ClassType>> symmetricManagers;
    private final Map<Type, GenPrimitiveClass> baseClassMapping = new HashMap<Type, GenPrimitiveClass>();
    private final Map<Type, GenClass> classMapping = new HashMap<Type, GenClass>();
    private final Map<Type, Tuple<GenType, Collection<ExceptionClassType>>> typeMapping = new HashMap<Type, Tuple<GenType, Collection<ExceptionClassType>>>();
    private final Map<GenClass, GenAspect> aspectJMapping;
    private GenClass setterInterface;
    private static final String ASPECT_SUFFIX = "Aspect";
    private static final String BASETYPE_EXPANSION_ASPECT_SUFFIX = "ExpansionAspect";
    private static final String ASPECT_COMMENT = "This is an aspect.";

    public GenClass getSetterInterface() {
        return this.setterInterface;
    }

    public void addNonAstClass(GenClass c) {
        this.nonASTClasses.add(c);
    }

    public void addSymmetricManager(GenUserClass manager, ClassType userClass) {
        if (!this.symmetricManagers.containsKey(manager)) {
            this.symmetricManagers.put(manager, new Vector());
        }
        this.symmetricManagers.get(manager).add(userClass);
    }

    public GenUserClass getSymmetricManager(ClassType clss1, ClassType clss2) {
        for (GenUserClass singleton : this.symmetricManagers.keySet()) {
            if (!this.symmetricManagers.get(singleton).contains(clss1) || !this.symmetricManagers.get(singleton).contains(clss2)) continue;
            return singleton;
        }
        return null;
    }

    public void addAspect(GenClass genClass, GenAspect aspect) {
        this.getAspectJMapping().put(genClass, aspect);
    }

    public Collection<GenClass> getClasses() {
        Vector<GenClass> res = new Vector<GenClass>();
        res.addAll(this.classMapping.values());
        res.addAll(this.nonASTClasses);
        res.addAll(this.aspectJMapping.values());
        return res;
    }

    public GeneratorModel() {
        this.nonASTClasses = new Vector();
        this.aspectJMapping = new HashMap<GenClass, GenAspect>();
        this.symmetricManagers = new HashMap<GenUserClass, Vector<ClassType>>();
    }

    public static GeneratorModel create() {
        return new GeneratorModel();
    }

    public void addToMapping(Type type, Tuple<GenType, Collection<ExceptionClassType>> genTypes) {
        final Type typeProxyFreePrototype = UtilTransformer.getTypeProxyFreePrototype(type);
        this.typeMapping.put(typeProxyFreePrototype, genTypes);
        genTypes.getA().accept(new GenTypeVisitor(){

            @Override
            public void handle(GenPrimitiveType primitiveType) {
                primitiveType.accept(new AddToMappingPrimitiveTypeVisitor(typeProxyFreePrototype));
            }

            @Override
            public void handle(GenCollectionType collectionType) {
            }

            @Override
            public void handle(GenClass cla) {
                GeneratorModel.this.getClassMapping().put(typeProxyFreePrototype, cla);
            }

            @Override
            public void handle(GenMapType mapType) {
            }

            @Override
            public void handle(Generic generic) {
            }

            @Override
            public void handle(GenJavaUtilCollection javaUtilCollection) {
            }

            @Override
            public void handle(GenImportType importType) {
            }

            @Override
            public void handle(GenDummyType dummy) {
            }
        });
    }

    public GenType getGenTypeForType(Type type) throws GenTypeNotReferencedException {
        Type protoType = UtilTransformer.getTypeProxyFreePrototype(type);
        Tuple<GenType, Collection<ExceptionClassType>> result = this.typeMapping.get(protoType);
        if (result == null || result.getA() == null) {
            throw new GenTypeNotReferencedException();
        }
        return result.getA();
    }

    public Collection<GenException> getGenExceptionsForType(Type type) throws TaskException {
        Type protoType = UtilTransformer.getTypeProxyFreePrototype(type);
        ArrayList<GenException> result = new ArrayList<GenException>();
        Collection<ExceptionClassType> exceptions = this.typeMapping.get(protoType).getB();
        for (ExceptionClassType current : exceptions) {
            Tuple<GenType, Collection<ExceptionClassType>> types = this.typeMapping.get(current.getPrototype());
            if (!(types.getA() instanceof GenException)) continue;
            result.add((GenException)types.getA());
        }
        return result;
    }

    public GenClass getJavaClassForWTFClass(Type type) {
        Type prototype = UtilTransformer.getTypeProxyFreePrototype(type);
        GenClass result = this.classMapping.get(prototype);
        if (result == null) {
            System.out.println("Impl class not found");
        }
        return result;
    }

    public GenUserClass createClass(String name, Collection<GenClassModifier> modifiers, Type type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        Vector<GenJavaAttribute> attributes = new Vector<GenJavaAttribute>();
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenJavaOperation> constructors = new Vector<GenJavaOperation>();
        Vector<GenInterfaceClass> implement = new Vector<GenInterfaceClass>();
        GenAnyType extend = GenAnyType.getInstance();
        return this.createClassInternal(name, attributes, operations, modifiers, constructors, implement, extend, type, comment, packag, nonGeneratedPart);
    }

    private GenUserClass createClassInternal(String name, Collection<GenJavaAttribute> attributes, Collection<GenJavaOperation> operations, Collection<GenClassModifier> modifiers, Collection<GenJavaOperation> constructors, Collection<GenInterfaceClass> implement, GenClassClass extend, Type type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        GenUserClass c = GenUserClass.create(name, operations, implement, attributes, modifiers, constructors, extend, packag, comment, nonGeneratedPart);
        return c;
    }

    public GenInterfaceClass createInterface(String name, Type type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenInterfaceClass> implement = new Vector<GenInterfaceClass>();
        return this.createInterfaceInternal(name, operations, implement, type, comment, packag, nonGeneratedPart);
    }

    private GenInterfaceClass createInterfaceInternal(String name, Vector<GenJavaOperation> operations, Vector<GenInterfaceClass> implement, Type type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        GenSimpleInterfaceClass c = GenSimpleInterfaceClass.create(name, operations, implement, packag, comment, nonGeneratedPart);
        return c;
    }

    public GenInterfaceWithClassImplClass createInterfaceWithImplClass(String name, ClassType type, Collection<GenClassModifier> classModifiers, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenInterfaceClass> implement = new Vector<GenInterfaceClass>();
        Vector<GenClassModifier> modifiers = new Vector<GenClassModifier>();
        for (GenClassModifier current : classModifiers) {
            if (current == GenClassModifier.ABSTRACT) continue;
            modifiers.add(current);
        }
        GenUserClass classRepresentation = this.createClass(name, modifiers, (Type)type, comment, packag, nonGeneratedPart);
        return this.createInterfaceWithImplClassInternal(name, operations, implement, (Type)type, comment, packag, nonGeneratedPart, classRepresentation);
    }

    private GenInterfaceWithClassImplClass createInterfaceWithImplClassInternal(String name, Vector<GenJavaOperation> operations, Vector<GenInterfaceClass> implement, Type type, GenComment comment, GenPackage packag, String nonGeneratedPart, GenUserClass classRepresentation) {
        GenInterfaceWithClassImplClass i = GenInterfaceWithClassImplClass.create(name, operations, implement, packag, comment, nonGeneratedPart, classRepresentation);
        return i;
    }

    public GenException createException(String name, ClassType type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        Vector<GenJavaAttribute> attributes = new Vector<GenJavaAttribute>();
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenClassModifier> modifiers = new Vector<GenClassModifier>();
        Vector<GenJavaOperation> constructors = new Vector<GenJavaOperation>();
        Vector<GenInterfaceClass> implement = new Vector<GenInterfaceClass>();
        return this.createExceptionInternal(name, attributes, operations, modifiers, constructors, implement, type, comment, packag, nonGeneratedPart);
    }

    private GenException createExceptionInternal(String name, Collection<GenJavaAttribute> attributes, Collection<GenJavaOperation> operations, Collection<GenClassModifier> modifiers, Collection<GenJavaOperation> constructors, Collection<GenInterfaceClass> implement, ClassType type, GenComment comment, GenPackage packag, String nonGeneratedPart) {
        GenException result = GenException.create(name, operations, implement, attributes, modifiers, constructors, packag, comment, nonGeneratedPart);
        return result;
    }

    public GenAspect getAspectForBaseTypeExpansion(BaseType baseType) throws GenTypeNotReferencedException {
        GenType genType = this.getGenTypeForType((Type)baseType);
        GenClass genClass = genType.accept(new GenTypeVisitorReturn<GenClass>(){

            @Override
            public GenClass handle(GenClass cla) {
                return cla;
            }

            @Override
            public GenClass handle(GenCollectionType collectionType) {
                return null;
            }

            @Override
            public GenClass handle(GenPrimitiveType primitiveType) {
                return primitiveType.accept(new GenPrimitiveTypeVisitorReturn<GenClass>(){

                    @Override
                    public GenClass handle(GenVoidType voidType) {
                        return null;
                    }

                    @Override
                    public GenClass handle(GenStringType stringType) {
                        return GenStringType.getCorrespondingClass();
                    }

                    @Override
                    public GenClass handle(GenIntegerType integerType) {
                        return GenIntegerType.getCorrespondingClass();
                    }
                });
            }

            @Override
            public GenClass handle(GenMapType mapType) {
                return null;
            }

            @Override
            public GenClass handle(GenImportType importType) {
                return null;
            }

            @Override
            public GenClass handle(GenDummyType dummyType) {
                return null;
            }

            @Override
            public GenClass handle(Generic generic) {
                return null;
            }

            @Override
            public GenClass handle(GenJavaUtilCollection javaUtilCollection) {
                return null;
            }
        });
        return this.getAspectForType(genClass);
    }

    public GenAspect getAspectForType(GenClass clazz) {
        if (this.getAspectJMapping().containsKey(clazz)) {
            return this.getAspectJMapping().get(clazz);
        }
        String name = clazz.getName() + BASETYPE_EXPANSION_ASPECT_SUFFIX;
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenAspectOperation> aspectOperations = new Vector<GenAspectOperation>();
        Vector<GenInterfaceClass> impl = new Vector<GenInterfaceClass>();
        Vector<GenJavaAttribute> attributes = new Vector<GenJavaAttribute>();
        Vector<GenAspectAttribute> aspectAttributes = new Vector<GenAspectAttribute>();
        Vector<GenClassModifier> modifiers = new Vector<GenClassModifier>();
        Vector<GenJavaOperation> constructors = new Vector<GenJavaOperation>();
        GenQualifiedPackage packag = PackageConstants.ASPECT_PACKAGE;
        GenComment comment = GenComment.createFromPlainText(ASPECT_COMMENT, false);
        GenAspect aspect = GenAspect.create(name, operations, aspectOperations, impl, attributes, aspectAttributes, modifiers, constructors, null, packag, comment, "");
        this.addAspect(clazz, aspect);
        return aspect;
    }

    public Map<Type, GenPrimitiveClass> getBaseClassMapping() {
        return this.baseClassMapping;
    }

    public Map<Type, GenClass> getClassMapping() {
        return this.classMapping;
    }

    public Map<Type, Tuple<GenType, Collection<ExceptionClassType>>> getTypeMapping() {
        return this.typeMapping;
    }

    public Map<GenClass, GenAspect> getAspectJMapping() {
        return this.aspectJMapping;
    }

    public Vector<GenClass> getNonAstType() {
        return this.nonASTClasses;
    }

    public void setSymmetricSetterInterface(GenClass setterInterface) {
        this.setterInterface = setterInterface;
    }

    private final class AddToMappingPrimitiveTypeVisitor
    implements GenPrimitiveTypeVisitor {
        private final Type wtfType;

        private AddToMappingPrimitiveTypeVisitor(Type wtfType) {
            this.wtfType = wtfType;
        }

        @Override
        public void handle(GenVoidType voidType) {
        }

        @Override
        public void handle(GenStringType stringType) {
            GeneratorModel.this.getBaseClassMapping().put(this.wtfType, GenStringType.getCorrespondingClass());
        }

        @Override
        public void handle(GenIntegerType integerType) {
            GeneratorModel.this.getBaseClassMapping().put(this.wtfType, GenIntegerType.getCorrespondingClass());
        }
    }
}

