package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;

/**
 * This state indicates an imported operation with full method.
 * 
 */
public final class GenSimpleOperationState implements GenOperationState {
	
	/**
	 * Implementation of the method with full operation header.
	 */
	private String fullOperationWithPossibleImplementation;
	
	/**
	 * Possible original model operation that is overwritten by this simple operation.
	 */
	private GenJavaOperation overwrittenOperation;
	
	/**
	 * Instantiates a new {@link GenSimpleOperationState}.
	 * 
	 * @param fullOperationWithPossibleImplementation
	 *            Implementation of the method with full operation header.
	 */
	private GenSimpleOperationState(final String fullOperationWithPossibleImplementation) {
		this.fullOperationWithPossibleImplementation = fullOperationWithPossibleImplementation;
	}
	
	/**
	 * Creates a new {@link GenSimpleOperationState}.
	 * 
	 * @param fullOperationWithPossibleImplementation
	 *            Implementation of the method with full operation header.
	 * @return {@link GenSimpleOperationState}
	 */
	public static GenSimpleOperationState create(final String fullOperationWithPossibleImplementation) {
		return new GenSimpleOperationState(fullOperationWithPossibleImplementation);
	}
	
	@Override
	public void accept(final GenOperationStateVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenOperationStateVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <Y extends Exception> void accept(final GenOperationStateVisitorException<Y> visitor) throws Y {
		visitor.handle(this);
	}
	
	@Override
	public <X, Y extends Exception> X accept(final GenOperationStateVisitorReturnException<X, Y> visitor) throws Y {
		return visitor.handle(this);
	}
	
	/**
	 * Returns the implementation of the method with full operation header.
	 * 
	 * @return String
	 */
	public String getFullOperationWithPossibleImplementation() {
		return this.fullOperationWithPossibleImplementation;
	}
	
	/**
	 * Sets the implementation of the method with full operation header.
	 * 
	 * @param fullOperationWithPossibleImplementation
	 *            The new implementation of the method with full operation header.
	 */
	public void setFullOperationWithPossibleImplementation(final String fullOperationWithPossibleImplementation) {
		this.fullOperationWithPossibleImplementation = fullOperationWithPossibleImplementation;
	}
	
	/**
	 * Returns the possible original model operation that is overwritten by this simple operation.
	 * 
	 * @return {@link GenJavaOperation}
	 */
	public GenJavaOperation getOverwrittenOperation() {
		return this.overwrittenOperation;
	}
	
	/**
	 * Sets the possible original model operation that is overwritten by this simple operation.
	 * 
	 * @param overwrittenOperation
	 *            The new operation that is the original model operation that is overwritten by this simple operation.
	 */
	public void setOverwrittenOperation(final GenJavaOperation overwrittenOperation) {
		this.overwrittenOperation = overwrittenOperation;
	}
}
