package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;

public class ConstructorSymmetricAttribute extends SimpleWalkerTask {
	
	private final GeneratorModel generatorModel;
	private final HashSet<ClassType> lst = new HashSet<ClassType>();
	
	private ClassType findCorrespondingType(final Attribute a) {
		final Iterator<ClassType> i = this.lst.iterator();
		while (i.hasNext()) {
			final ClassType current = i.next();
			final String str1 = (current.getName() + "").trim().toLowerCase();
			final String str2 = (a.getAttrType().getTypeString()).trim().toLowerCase();
			if (str1.equals(str2)) {
				System.out.println("------> findCorrespondingType: NOT NULL");
				return current;
			}
		}
		System.out.println("------> findCorrespondingType: IS NULL");
		return null;
	}
	
	public ConstructorSymmetricAttribute(final Model m,
			final TaskExecutor taskmanager,
			final GeneratorModel generatorModel) {
		super(m, taskmanager);
		this.generatorModel = generatorModel;
	}
	
	@Override
	public void handleClass(final ClassType c) throws TaskException {
		final Iterator<Attribute> i = c.getAttributes().iterator();
		while (i.hasNext()) {
			final Attribute current = i.next();
			if (current.isSymmetric()) {
				if (this.lst.contains(c) == false) {
					this.lst.add(c);
				}
			}
		}
	}
	
	@Override
	public void handleGroup(final Group g) throws TaskException {
		// Leer
	}
	
	@Override
	public void handleAttribute(final Attribute a, final ClassType owner) throws TaskException {
		// Leer
	}
	
	@Override
	public void handleConstructorOrOperation(final ConstructorOrOperation coo, final ClassType owner)
			throws TaskException {
		// Leer
	}
	
	public String getSetterName(final ClassType clss1, final ClassType clss2, final ClassType wantedType) {
		final String[] str = { clss1.getName().getLastAddedName() + "", clss2.getName().getLastAddedName() + "" };
		Arrays.sort(str);
		if (str[0].equals(wantedType.getName().getLastAddedName() + "")) {
			return "registerSetter1";
		}
		if (str[1].equals(wantedType.getName().getLastAddedName() + "")) {
			return "registerSetter2";
		}
		return "-notFound-";
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		try {
			final Iterator<ClassType> i1 = this.lst.iterator();
			while (i1.hasNext()) {
				final ClassType clss = i1.next();
				System.out.println("------> Klasse: " + clss.getName());
				final Iterator<Attribute> i2 = clss.getAttributes().iterator();
				while (i2.hasNext()) {
					final Attribute att = i2.next();
					if (att.isSymmetric() == false) {
						continue;
					}
					
					final ClassType correspondingType = this.findCorrespondingType(att);
					final GenUserClass singleton = this.generatorModel.getSymmetricManager(clss, correspondingType);
					
					if (singleton == null) {
						System.out.println("------> Singleton is null!");
						return;
					}
					
					final String singletonName = singleton.getName();
					final String singletonInstance = ".getInstance().";
					final String setterName = this.getSetterName(clss, correspondingType, clss);
					final String setterCall = singletonName + singletonInstance + setterName;
					
					// Aufruf in jedem Constructor von beispielsweise A$Impl
					final String content =
							"\t\t" + setterCall + "(this, new " + (clss.getName() + "").replace('>', '.')
									+ "Setter());";
					
					// Bsp.: Finde Klasse "A"
					final GenClass genClss = this.generatorModel.getJavaClassForWTFClass(clss);
					
					// Bsp.: Hole Klasse "A$Impl"
					final GenClassClass genClssClss = genClss.getImplementor();
					
					// Füge Import des Singleton-Symmetric-Managers in beispielsweise A$Impl hinzu
					genClssClss.setImports(genClssClss.getImports() + System.lineSeparator() + "import "
							+ singleton.getPackag().toString() + ".*;");
					
					// Output zum Debugging (wenn nötig)
					System.out.println("------> genClss     : " + genClss.getFullyQualifiedTypeName());
					System.out.println("------> genClssClss : " + genClssClss.getFullyQualifiedTypeName());
					
					// Durchlaufe nun jeden Constructor
					final Iterator<GenJavaOperation> opIt = genClssClss.getConstructors().iterator();
					while (opIt.hasNext()) {
						final GenJavaOperation op = opIt.next();
						op.getState().accept(new GenOperationStateVisitor() {
							
							@Override
							public void handle(final GenFullParsedOperationState s) {
								s.setMethodBody(s.getMethodBody() + System.lineSeparator() + content);
							}
							
							@Override
							public void handle(final GenSimpleOperationState s) {
								// Leer
							}
						});
					}
				}
			}
		} catch (final Exception e) {
			System.out.println("----------> ERROR: " + e.getMessage());
			e.printStackTrace();
		}
	}
	
	@Override
	public void beginTask() throws TaskException {
		// Leer
	}
	
}
