/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.visitorTransformation;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.InheritanceTransformer;
import de.fhdw.wtf.generator.transformer.visitorTransformation.UtilVisitorTransformer;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class VisitorTypeTransformer
extends SimpleWalkerTaskForTypes {
    private final GeneratorModel generatorModel;
    private GenException currentException = null;
    private GenType currentReturnType = null;
    private final Map<GenInterfaceClass, List<GenType>> handledTypes = new HashMap<GenInterfaceClass, List<GenType>>();

    private VisitorTypeTransformer(Model m, TaskExecutor taskmanager, GeneratorModel genModel, InheritanceTransformer inheritanceTransformer) {
        super(m, taskmanager, true);
        this.generatorModel = genModel;
        try {
            this.addDependency((DependencyTask)inheritanceTransformer);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in VisitorTypeTransformer.");
        }
    }

    public static VisitorTypeTransformer create(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel, InheritanceTransformer inheritanceTransformer) {
        return new VisitorTypeTransformer(m, taskmanager, generatorModel, inheritanceTransformer);
    }

    private void processClassType(ClassType type) {
        if (UtilVisitorTransformer.isVisitable(type)) {
            this.createVisitorWithoutReturnAndException(type, true);
            this.createVisitorWithoutReturnAndException(type, false);
            this.createVisitorWithReturnWithoutException(type, true);
            this.createVisitorWithReturnWithoutException(type, false);
            this.createVisitorWithoutReturnWithException(type, true);
            this.createVisitorWithoutReturnWithException(type, false);
            this.createVisitorWitReturnAndException(type, false);
            this.createVisitorWitReturnAndException(type, true);
        }
    }

    private void createVisitorWitReturnAndException(ClassType c, boolean full) {
        String intName = this.getVisitorInterfaceName(c, full, true, true);
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
        javaExceptionPackage = ((GenPackage)javaExceptionPackage).addName("lang");
        GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
        Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
        Generic genericReturn = Generic.create("X", GenHasNoGenericType.create());
        GenComment visitorDefaultComment = GenComment.createFromPlainText("This class represents a visitor.", false);
        Vector<GenInterfaceClass> impls = new Vector<GenInterfaceClass>();
        GenSimpleInterfaceClass visitorInterface = GenSimpleInterfaceClass.create(intName, operations, impls, PackageConstants.VISITOR_PACKAGE, visitorDefaultComment, "");
        visitorInterface.getGenerics().add(genericReturn);
        visitorInterface.getGenerics().add(genericException);
        GenJavaOperation acceptOperation = this.createAcceptOperation(c, visitorInterface, genericReturn);
        acceptOperation.getGenerics().add(genericException);
        acceptOperation.getParameters().get(0).getGenerics().add(genericException);
        this.addException(acceptOperation, this.getGeneratorModelException(genericException));
        this.createVisitorWithReturnAndExceptionHandleOperations(c.getSubTypes(), visitorInterface, genericReturn, genericException, full);
        this.getGeneratorModel().addNonAstClass(visitorInterface);
    }

    private void createVisitorWithoutReturnWithException(ClassType c, boolean full) {
        String intName = this.getVisitorInterfaceName(c, full, false, true);
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
        javaExceptionPackage = ((GenPackage)javaExceptionPackage).addName("lang");
        GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
        Generic generic = Generic.create("Y", GenHasGenericType.create(javaException));
        GenComment visitorDefaultComment = GenComment.createFromPlainText("This class represents a visitor.", false);
        Vector<GenInterfaceClass> impls = new Vector<GenInterfaceClass>();
        GenSimpleInterfaceClass visitorInterface = GenSimpleInterfaceClass.create(intName, operations, impls, PackageConstants.VISITOR_PACKAGE, visitorDefaultComment, "");
        visitorInterface.getGenerics().add(generic);
        GenJavaOperation acceptOperation = this.createAcceptOperation(c, visitorInterface, GenVoidType.getInstance());
        acceptOperation.getGenerics().add(generic);
        acceptOperation.getParameters().get(0).getGenerics().add(generic);
        this.addException(acceptOperation, this.getGeneratorModelException(generic));
        this.createVisitorWithoutReturnWithExceptionHandleOperations(c.getSubTypes(), visitorInterface, generic, full);
        this.getGeneratorModel().addNonAstClass(visitorInterface);
    }

    private void createVisitorWithReturnWithoutException(ClassType c, boolean full) {
        String intName = this.getVisitorInterfaceName(c, full, true, false);
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Generic generic = Generic.create("X", GenHasNoGenericType.create());
        GenComment visitorDefaultComment = GenComment.createFromPlainText("This class represents a visitor.", false);
        Vector<GenInterfaceClass> impls = new Vector<GenInterfaceClass>();
        GenSimpleInterfaceClass visitorInterface = GenSimpleInterfaceClass.create(intName, operations, impls, PackageConstants.VISITOR_PACKAGE, visitorDefaultComment, "");
        visitorInterface.getGenerics().add(generic);
        this.createAcceptOperation(c, visitorInterface, generic);
        this.createVisitorWithReturnWithoutExceptionHandleOperations(c.getSubTypes(), visitorInterface, generic, full);
        this.getGeneratorModel().addNonAstClass(visitorInterface);
    }

    private GenInterfaceClass createVisitorWithoutReturnAndException(ClassType c, boolean full) {
        String intName = this.getVisitorInterfaceName(c, full, false, false);
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        GenComment visitorDefaultComment = GenComment.createFromPlainText("This class represents a visitor.", false);
        Vector<GenInterfaceClass> impls = new Vector<GenInterfaceClass>();
        GenSimpleInterfaceClass visitorInterface = GenSimpleInterfaceClass.create(intName, operations, impls, PackageConstants.VISITOR_PACKAGE, visitorDefaultComment, "");
        this.createAcceptOperation(c, visitorInterface, GenVoidType.getInstance());
        this.createVisitorWithoutReturnAndExceptionHandleOperations(c.getSubTypes(), visitorInterface, GenVoidType.getInstance(), full);
        this.getGeneratorModel().addNonAstClass(visitorInterface);
        return visitorInterface;
    }

    private GenJavaOperation createAcceptOperation(ClassType c, GenInterfaceClass visitorInterface, GenType returnType) {
        Vector<GenParameter> params = new Vector<GenParameter>();
        final GenParameter param = GenParameter.create("visitor", visitorInterface);
        params.add(param);
        Vector<GenException> exceptions = new Vector<GenException>();
        GenComment comment = GenComment.createFromPlainText("This operation is part of a visitor.", true);
        Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
        if (c.isAbstract()) {
            modifiers.add(GenOperationModifier.ABSTRACT);
        }
        String acceptMethod = "";
        acceptMethod = this.isGeneric(returnType) ? "return visitor.handle(this);" : "visitor.handle(this);";
        final GenJavaOperation acceptAbstract = GenJavaOperation.create("accept", GenVisibility.PUBLIC, params, exceptions, acceptMethod, returnType, modifiers, comment);
        returnType.accept(new GenTypeVisitor(){

            @Override
            public void handle(GenImportType importType) {
            }

            @Override
            public void handle(Generic generic) {
                param.getGenerics().add(generic);
                acceptAbstract.getGenerics().add(generic);
            }

            @Override
            public void handle(GenMapType mapType) {
            }

            @Override
            public void handle(GenPrimitiveType primitiveType) {
            }

            @Override
            public void handle(GenCollectionType collectionType) {
            }

            @Override
            public void handle(GenClass cla) {
            }

            @Override
            public void handle(GenJavaUtilCollection javaUtilCollection) {
            }

            @Override
            public void handle(GenDummyType dummy) {
            }
        });
        GenClass genOwner = this.getGeneratorModel().getClassMapping().get(c);
        genOwner.accept(new GenClassVisitor(){

            @Override
            public void handle(GenPrimitiveClass primitiveClass) {
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) {
                interfaceClass.accept(new GenInterfaceClassVisitor(){

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                        interfaceWithImplClass.addOperation(acceptAbstract);
                        interfaceWithImplClass.getClassRepresentation().addOperation(acceptAbstract);
                    }

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) {
                        simpleInterface.addOperation(acceptAbstract);
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) {
                        throw new Error("Operation " + acceptAbstract.getName() + " cannot be added to external interface " + iface.getFullyQualifiedTypeName());
                    }
                });
            }

            @Override
            public void handle(GenClassClass classClass) {
                classClass.addOperation(acceptAbstract);
            }
        });
        return acceptAbstract;
    }

    private GenException getGeneratorModelException(GenType type) {
        GenException exception = GenException.create(type.getName(), new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), GenUnqualifiedPackage.create(""), GenComment.createFromPlainText("", true), "");
        this.setCurrentException(exception);
        return exception;
    }

    private boolean isGeneric(GenType returnType) {
        return returnType.accept(new GenTypeVisitorReturn<Boolean>(){

            @Override
            public Boolean handle(GenClass cla) {
                return false;
            }

            @Override
            public Boolean handle(GenCollectionType collectionType) {
                return false;
            }

            @Override
            public Boolean handle(GenPrimitiveType primitiveType) {
                return false;
            }

            @Override
            public Boolean handle(GenMapType mapType) {
                return false;
            }

            @Override
            public Boolean handle(GenImportType importType) {
                return false;
            }

            @Override
            public Boolean handle(GenDummyType dummyType) {
                return false;
            }

            @Override
            public Boolean handle(Generic generic) {
                return true;
            }

            @Override
            public Boolean handle(GenJavaUtilCollection javaUtilCollection) {
                return false;
            }
        });
    }

    private void createVisitorWithoutReturnWithExceptionHandleOperations(Collection<ClassType> subTypes, GenInterfaceClass visitorInterface, Generic generic, boolean full) {
        for (ClassType current : subTypes) {
            if (!current.isAbstract()) {
                Vector<GenParameter> params = new Vector<GenParameter>();
                GenParameter param = GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase().substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
                params.add(param);
                Vector<GenException> exceptions = new Vector<GenException>();
                exceptions.add(this.getCurrentException());
                GenComment comment = GenComment.createFromPlainText("This operation is part of a visitor.", true);
                Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
                GenJavaOperation handleOperationClass = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, exceptions, "", GenVoidType.getInstance(), modifiers, comment);
                visitorInterface.addOperation(handleOperationClass);
                GenJavaOperation acceptOperation = this.createAcceptOperation(current, visitorInterface, GenVoidType.getInstance());
                this.addException(acceptOperation, this.getCurrentException());
                acceptOperation.getGenerics().add(generic);
                acceptOperation.getParameters().get(0).getGenerics().add(generic);
            }
            if (!full) continue;
            this.createVisitorWithoutReturnWithExceptionHandleOperations(current.getSubTypes(), visitorInterface, generic, full);
        }
    }

    private void addException(GenJavaOperation operation, final GenException exception) {
        operation.getState().accept(new GenOperationStateVisitor(){

            @Override
            public void handle(GenFullParsedOperationState s) {
                s.getExceptions().add(exception);
            }

            @Override
            public void handle(GenSimpleOperationState s) {
            }
        });
    }

    private void createVisitorWithoutReturnAndExceptionHandleOperations(Collection<ClassType> subTypes, GenInterfaceClass visitorInterface, GenType returnType, boolean full) {
        for (ClassType current : subTypes) {
            if (!current.isAbstract()) {
                Vector<GenParameter> params = new Vector<GenParameter>();
                GenParameter param = GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase().substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
                params.add(param);
                Vector<GenException> exceptions = new Vector<GenException>();
                GenComment comment = GenComment.createFromPlainText("This operation is part of a visitor.", true);
                Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
                GenJavaOperation handleOperationClass = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, exceptions, "", returnType, modifiers, comment);
                visitorInterface.addOperation(handleOperationClass);
                this.createAcceptOperation(current, visitorInterface, returnType);
            }
            if (!full) continue;
            this.createVisitorWithoutReturnAndExceptionHandleOperations(current.getSubTypes(), visitorInterface, returnType, full);
        }
    }

    private void createVisitorWithReturnWithoutExceptionHandleOperations(Collection<ClassType> subTypes, GenInterfaceClass visitorInterface, Generic generic, boolean full) {
        this.createVisitorWithoutReturnAndExceptionHandleOperations(subTypes, visitorInterface, generic, full);
    }

    private void createVisitorWithReturnAndExceptionHandleOperations(Collection<ClassType> subTypes, GenInterfaceClass visitorInterface, Generic genericReturn, Generic genericException, boolean full) {
        for (ClassType current : subTypes) {
            if (!current.isAbstract()) {
                Vector<GenParameter> params = new Vector<GenParameter>();
                GenParameter param = GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase().substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
                params.add(param);
                Vector<GenException> exceptions = new Vector<GenException>();
                exceptions.add(this.getCurrentException());
                GenComment comment = GenComment.createFromPlainText("This operation is part of a visitor.", true);
                Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
                GenJavaOperation handleOperationClass = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, exceptions, "", genericReturn, modifiers, comment);
                visitorInterface.addOperation(handleOperationClass);
                GenJavaOperation acceptOperation = this.createAcceptOperation(current, visitorInterface, genericReturn);
                acceptOperation.getGenerics().add(genericException);
                acceptOperation.getParameters().get(0).getGenerics().add(genericException);
                this.addException(acceptOperation, this.getCurrentException());
            }
            if (!full) continue;
            this.createVisitorWithReturnAndExceptionHandleOperations(current.getSubTypes(), visitorInterface, genericReturn, genericException, full);
        }
    }

    private String getVisitorInterfaceName(ClassType c, boolean full, boolean returnValue, boolean exception) {
        String result = this.getGeneratorModel().getClassMapping().get(c).getName();
        result = full ? result + "$Visitor" : result + "$PartialVisitor";
        if (returnValue) {
            result = result + "Return";
        }
        if (exception) {
            result = result + "Exception";
        }
        return result;
    }

    public void handleType(Type c) throws TaskException {
        c.accept((TypeVisitorException)new TypeVisitorException<TaskException>(){

            public void handle(AtomicType s) throws TaskException {
                s.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<TaskException>(){

                    public void handle(BaseType baseType) throws TaskException {
                    }

                    public void handle(ClassType clazz) throws TaskException {
                        VisitorTypeTransformer.this.processClassType(clazz);
                    }
                });
            }

            public void handle(CompositeType compositeType) throws TaskException {
                compositeType.accept((CompositeTypeVisitorException)new CompositeTypeVisitorException<TaskException>(){

                    public void handle(MapType arg0) {
                    }

                    public void handle(ProductType arg0) {
                    }

                    public void handle(SumType s) throws TaskException {
                        if (s.getElementsSizeWithoutThrownTypes() > 1) {
                            VisitorTypeTransformer.this.createPartialVisitorsSum(s);
                            VisitorTypeTransformer.this.createFullVisitorsSum(s);
                        }
                    }

                    public void handle(ListType list) {
                    }

                    public void handle(ThrownType thrownType) throws TaskException {
                    }
                });
            }

            public void handle(TypeProxy s) throws TaskException {
            }
        });
    }

    private void addVoidHandleToVisitor(GenInterfaceClass visitor, GenType toHandle) {
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
        GenJavaOperation handle = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This operation is part of a visitor.", true));
        visitor.addOperation(handle);
    }

    private void addReturnHandleToVisitor(GenInterfaceClass visitor, GenType toHandle) {
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
        GenJavaOperation handle = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "", this.getCurrentReturnType(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This operation is part of a visitor.", true));
        visitor.addOperation(handle);
    }

    private void addExceptionHandleToVisitor(GenInterfaceClass visitor, GenType toHandle) {
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
        GenJavaOperation handle = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This operation is part of a visitor.", true));
        this.addException(handle, this.getCurrentException());
        visitor.addOperation(handle);
    }

    private void addReturnExceptionHandleToVisitor(GenInterfaceClass visitor, GenType toHandle) {
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
        GenJavaOperation handle = GenJavaOperation.create("handle", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "", this.getCurrentReturnType(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This operation is part of a visitor.", true));
        this.addException(handle, this.getCurrentException());
        visitor.addOperation(handle);
    }

    private void createPartialVisitorsSum(SumType s) throws TaskException {
        GenType sumType = this.getGeneratorModel().getGenTypeForType((Type)s);
        GenPackage visPackage = PackageConstants.VISITOR_PACKAGE;
        GenSimpleInterfaceClass sumVisitorPartialVoid = GenSimpleInterfaceClass.create(sumType.getName() + "$PartialVisitor", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create("visitor", sumVisitorPartialVoid));
        GenJavaOperation accept = GenJavaOperation.create("accept", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "visitor.handle(this);", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        this.assumeClassAndAddOperation(sumType, accept);
        this.acceptVisitorInSum(s, sumVisitorPartialVoid, accept, true, true, false);
        this.getGeneratorModel().addNonAstClass(sumVisitorPartialVoid);
        GenSimpleInterfaceClass sumVisitorPartialReturn = GenSimpleInterfaceClass.create(sumType.getName() + "$PartialVisitor" + "Return", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        Generic genericReturn = Generic.create("X", GenHasNoGenericType.create());
        sumVisitorPartialReturn.getGenerics().add(genericReturn);
        ArrayList<GenParameter> paramsReturn = new ArrayList<GenParameter>();
        GenParameter paramReturn = GenParameter.create("visitor", sumVisitorPartialReturn);
        paramReturn.getGenerics().add(genericReturn);
        paramsReturn.add(paramReturn);
        GenJavaOperation acceptReturn = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsReturn, new ArrayList<GenException>(), "return visitor.handle(this);", genericReturn, new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptReturn.getGenerics().add(genericReturn);
        this.setCurrentReturnType(genericReturn);
        this.assumeClassAndAddOperation(sumType, acceptReturn);
        this.acceptVisitorInSum(s, sumVisitorPartialReturn, acceptReturn, true, false, false);
        this.getGeneratorModel().addNonAstClass(sumVisitorPartialReturn);
        GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
        javaExceptionPackage = ((GenPackage)javaExceptionPackage).addName("lang");
        GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
        Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
        GenSimpleInterfaceClass sumVisitorPartialException = GenSimpleInterfaceClass.create(sumType.getName() + "$PartialVisitor" + "Exception", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        sumVisitorPartialException.getGenerics().add(genericException);
        ArrayList<GenParameter> paramsException = new ArrayList<GenParameter>();
        GenParameter paramException = GenParameter.create("visitor", sumVisitorPartialException);
        paramException.getGenerics().add(genericException);
        paramsException.add(paramException);
        GenJavaOperation acceptException = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsException, new ArrayList<GenException>(), "visitor.handle(this);", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptException.getGenerics().add(genericException);
        this.addException(acceptException, this.getGeneratorModelException(genericException));
        this.assumeClassAndAddOperation(sumType, acceptException);
        this.acceptVisitorInSum(s, sumVisitorPartialException, acceptException, true, true, true);
        this.getGeneratorModel().addNonAstClass(sumVisitorPartialException);
        GenSimpleInterfaceClass sumVisitorPartialReturnException = GenSimpleInterfaceClass.create(sumType.getName() + "$PartialVisitor" + "Return" + "Exception", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        ArrayList<GenParameter> paramsReturnException = new ArrayList<GenParameter>();
        GenParameter paramReturnException = GenParameter.create("visitor", sumVisitorPartialReturnException);
        Generic genericReturn2 = Generic.create("X", GenHasNoGenericType.create());
        sumVisitorPartialReturnException.getGenerics().add(genericReturn2);
        sumVisitorPartialReturnException.getGenerics().add(genericException);
        paramReturnException.getGenerics().add(genericReturn2);
        paramReturnException.getGenerics().add(genericException);
        paramsReturnException.add(paramReturnException);
        GenJavaOperation acceptReturnException = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsReturnException, new ArrayList<GenException>(), "return visitor.handle(this);", genericReturn2, new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptReturnException.getGenerics().add(genericReturn2);
        acceptReturnException.getGenerics().add(genericException);
        this.addException(acceptReturnException, this.getCurrentException());
        this.setCurrentReturnType(genericReturn2);
        this.assumeClassAndAddOperation(sumType, acceptReturnException);
        this.acceptVisitorInSum(s, sumVisitorPartialReturnException, acceptReturnException, true, false, true);
        this.getGeneratorModel().addNonAstClass(sumVisitorPartialReturnException);
    }

    private void createFullVisitorsSum(SumType s) throws TaskException {
        GenType sumType = this.getGeneratorModel().getGenTypeForType((Type)s);
        GenPackage visPackage = PackageConstants.VISITOR_PACKAGE;
        GenSimpleInterfaceClass sumVisitorFull = GenSimpleInterfaceClass.create(sumType.getName() + "$Visitor", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        ArrayList<GenParameter> params = new ArrayList<GenParameter>();
        params.add(GenParameter.create("visitor", sumVisitorFull));
        GenJavaOperation accept = GenJavaOperation.create("accept", GenVisibility.PUBLIC, params, new ArrayList<GenException>(), "visitor.handle(this);", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        this.assumeClassAndAddOperation(sumType, accept);
        this.acceptVisitorInSum(s, sumVisitorFull, accept, false, true, false);
        this.getGeneratorModel().addNonAstClass(sumVisitorFull);
        GenSimpleInterfaceClass sumVisitorFullReturn = GenSimpleInterfaceClass.create(sumType.getName() + "$Visitor" + "Return", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        Generic generic = Generic.create("X", GenHasNoGenericType.create());
        sumVisitorFullReturn.getGenerics().add(generic);
        ArrayList<GenParameter> paramsReturn = new ArrayList<GenParameter>();
        GenParameter paramReturn = GenParameter.create("visitor", sumVisitorFullReturn);
        paramReturn.getGenerics().add(generic);
        paramsReturn.add(paramReturn);
        GenJavaOperation acceptReturn = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsReturn, new ArrayList<GenException>(), "return visitor.handle(this);", generic, new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptReturn.getGenerics().add(generic);
        this.assumeClassAndAddOperation(sumType, acceptReturn);
        this.acceptVisitorInSum(s, sumVisitorFullReturn, acceptReturn, false, false, false);
        this.getGeneratorModel().addNonAstClass(sumVisitorFullReturn);
        GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
        javaExceptionPackage = ((GenPackage)javaExceptionPackage).addName("lang");
        GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
        Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
        GenSimpleInterfaceClass sumVisitorFullException = GenSimpleInterfaceClass.create(sumType.getName() + "$Visitor" + "Exception", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        sumVisitorFullException.getGenerics().add(genericException);
        ArrayList<GenParameter> paramsException = new ArrayList<GenParameter>();
        GenParameter paramException = GenParameter.create("visitor", sumVisitorFullException);
        paramException.getGenerics().add(genericException);
        paramsException.add(paramException);
        GenJavaOperation acceptException = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsException, new ArrayList<GenException>(), "visitor.handle(this);", GenVoidType.getInstance(), new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptException.getGenerics().add(genericException);
        this.addException(acceptException, this.getGeneratorModelException(genericException));
        this.assumeClassAndAddOperation(sumType, acceptException);
        this.acceptVisitorInSum(s, sumVisitorFullException, acceptException, false, true, true);
        this.getGeneratorModel().addNonAstClass(sumVisitorFullException);
        GenSimpleInterfaceClass sumVisitorFullReturnException = GenSimpleInterfaceClass.create(sumType.getName() + "$Visitor" + "Return" + "Exception", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), visPackage, GenComment.createFromPlainText("This is a Visitor for the hierarchie of " + sumType.getName(), false), "");
        ArrayList<GenParameter> paramsReturnException = new ArrayList<GenParameter>();
        GenParameter paramReturnException = GenParameter.create("visitor", sumVisitorFullReturnException);
        Generic genericReturn2 = Generic.create("X", GenHasNoGenericType.create());
        sumVisitorFullReturnException.getGenerics().add(genericReturn2);
        sumVisitorFullReturnException.getGenerics().add(genericException);
        paramReturnException.getGenerics().add(genericReturn2);
        paramReturnException.getGenerics().add(genericException);
        paramsReturnException.add(paramReturnException);
        GenJavaOperation acceptReturnException = GenJavaOperation.create("accept", GenVisibility.PUBLIC, paramsReturnException, new ArrayList<GenException>(), "return visitor.handle(this);", genericReturn2, new ArrayList<GenOperationModifier>(), GenComment.createFromPlainText("This is an accept-Operation for a visitor.", true));
        acceptReturnException.getGenerics().add(genericReturn2);
        acceptReturnException.getGenerics().add(genericException);
        this.addException(acceptReturnException, this.getCurrentException());
        this.assumeClassAndAddOperation(sumType, acceptReturnException);
        this.acceptVisitorInSum(s, sumVisitorFullReturnException, acceptReturnException, false, false, true);
        this.getGeneratorModel().addNonAstClass(sumVisitorFullReturnException);
    }

    private void acceptVisitorInSum(SumType s, GenInterfaceClass visitor, GenJavaOperation accept, boolean partial, boolean isVoid, boolean hasException) throws TaskException {
        for (Type type : s.getElements()) {
            if (partial) {
                this.acceptVisitorInAstTypePartial(type, visitor, accept, isVoid, hasException);
                continue;
            }
            this.acceptVisitorInAstTypeFull(type, visitor, accept, isVoid, hasException);
        }
    }

    private void addHandleOperation(GenInterfaceClass visitor, GenType genType, boolean isVoid, boolean hasException) {
        if (isVoid && !hasException) {
            this.addVoidHandleToVisitor(visitor, genType);
        } else if (isVoid && hasException) {
            this.addExceptionHandleToVisitor(visitor, genType);
        } else if (!isVoid && !hasException) {
            this.addReturnHandleToVisitor(visitor, genType);
        } else {
            this.addReturnExceptionHandleToVisitor(visitor, genType);
        }
    }

    private void acceptVisitorInAstTypePartial(Type astType, final GenInterfaceClass visitor, final GenJavaOperation accept, final boolean isVoid, final boolean hasException) throws TaskException {
        astType.accept((TypeVisitorException)new TypeVisitorException<TaskException>(){

            public void handle(AtomicType s) throws TaskException {
                s.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<TaskException>(){

                    public void handle(BaseType b) throws TaskException {
                        VisitorTypeTransformer.this.addAcceptOperationToBaseType(b, accept);
                        GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)b);
                        VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                    }

                    public void handle(final ClassType c) throws TaskException {
                        final GenClass genType = (GenClass)VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)c);
                        genType.accept(new GenClassVisitorException<TaskException>(){

                            @Override
                            public void handle(GenClassClass classClass) throws TaskException {
                                if (!classClass.getModifieres().contains((Object)GenClassModifier.ABSTRACT)) {
                                    if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
                                        VisitorTypeTransformer.this.addHandledType(visitor, genType);
                                        classClass.addOperation(accept);
                                        VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                                    }
                                } else {
                                    for (ClassType astClass : c.getSubTypes()) {
                                        VisitorTypeTransformer.this.acceptVisitorInAstTypePartial((Type)astClass, visitor, accept, isVoid, hasException);
                                    }
                                }
                            }

                            @Override
                            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                                final 1 gcv = this;
                                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                                    @Override
                                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                                        gcv.handle(interfaceWithImplClass.getClassRepresentation());
                                    }

                                    @Override
                                    public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                                        for (ClassType astClass : c.getSubTypes()) {
                                            VisitorTypeTransformer.this.acceptVisitorInAstTypePartial((Type)astClass, visitor, accept, isVoid, hasException);
                                        }
                                    }

                                    @Override
                                    public void handle(GenExternalInterfaceClass iface) {
                                    }
                                });
                            }

                            @Override
                            public void handle(GenPrimitiveClass primitiveClass) {
                            }
                        });
                    }
                });
            }

            public void handle(CompositeType c) throws TaskException {
                c.accept((CompositeTypeVisitorException)new CompositeTypeVisitorException<TaskException>(){

                    public void handle(MapType arg0) {
                    }

                    public void handle(ProductType p) throws TaskException {
                        GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)p);
                        if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
                            VisitorTypeTransformer.this.addHandledType(visitor, genType);
                            VisitorTypeTransformer.this.assumeClassAndAddOperation(genType, accept);
                            VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                        }
                    }

                    public void handle(SumType s) throws TaskException {
                        VisitorTypeTransformer.this.acceptVisitorInSum(s, visitor, accept, true, isVoid, hasException);
                    }

                    public void handle(ListType list) {
                    }

                    public void handle(ThrownType thrownType) throws TaskException {
                    }
                });
            }

            public void handle(TypeProxy s) throws TaskException {
                VisitorTypeTransformer.this.acceptVisitorInAstTypePartial((Type)HelperUtils.getTargetAtomicType((TypeProxy)s), visitor, accept, isVoid, hasException);
            }
        });
    }

    private void acceptVisitorInAstTypeFull(Type astType, final GenInterfaceClass visitor, final GenJavaOperation accept, final boolean isVoid, final boolean hasException) throws TaskException {
        astType.accept((TypeVisitorException)new TypeVisitorException<TaskException>(){

            public void handle(AtomicType s) throws TaskException {
                s.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<TaskException>(){

                    public void handle(BaseType b) throws TaskException {
                        VisitorTypeTransformer.this.addAcceptOperationToBaseType(b, accept);
                        GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)b);
                        VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                    }

                    public void handle(final ClassType c) throws TaskException {
                        final GenClass genType = (GenClass)VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)c);
                        genType.accept(new GenClassVisitorException<TaskException>(){

                            @Override
                            public void handle(GenClassClass classClass) throws TaskException {
                                if (!classClass.getModifieres().contains((Object)GenClassModifier.ABSTRACT) && !VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
                                    VisitorTypeTransformer.this.addHandledType(visitor, genType);
                                    classClass.addOperation(accept);
                                    VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                                }
                                for (ClassType astClass : c.getSubTypes()) {
                                    VisitorTypeTransformer.this.acceptVisitorInAstTypeFull((Type)astClass, visitor, accept, isVoid, hasException);
                                }
                            }

                            @Override
                            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                                final 1 gcv = this;
                                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                                    @Override
                                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                                        gcv.handle(interfaceWithImplClass.getClassRepresentation());
                                    }

                                    @Override
                                    public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                                    }

                                    @Override
                                    public void handle(GenExternalInterfaceClass iface) {
                                    }
                                });
                                for (ClassType astClass : c.getSubTypes()) {
                                    VisitorTypeTransformer.this.acceptVisitorInAstTypeFull((Type)astClass, visitor, accept, isVoid, hasException);
                                }
                            }

                            @Override
                            public void handle(GenPrimitiveClass primitiveClass) {
                            }
                        });
                    }
                });
            }

            public void handle(CompositeType c) throws TaskException {
                c.accept((CompositeTypeVisitorException)new CompositeTypeVisitorException<TaskException>(){

                    public void handle(MapType arg0) {
                    }

                    public void handle(ProductType p) throws GenTypeNotReferencedException {
                        GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType((Type)p);
                        if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
                            VisitorTypeTransformer.this.addHandledType(visitor, genType);
                            VisitorTypeTransformer.this.assumeClassAndAddOperation(genType, accept);
                            VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
                        }
                    }

                    public void handle(SumType s) throws TaskException {
                        VisitorTypeTransformer.this.acceptVisitorInSum(s, visitor, accept, false, isVoid, hasException);
                    }

                    public void handle(ListType list) {
                    }

                    public void handle(ThrownType thrownType) throws TaskException {
                    }
                });
            }

            public void handle(TypeProxy s) throws TaskException {
                VisitorTypeTransformer.this.acceptVisitorInAstTypeFull((Type)HelperUtils.getTargetAtomicType((TypeProxy)s), visitor, accept, isVoid, hasException);
            }
        });
    }

    private void addAcceptOperationToBaseType(BaseType baseType, GenJavaOperation accept) throws GenTypeNotReferencedException {
        GenClass owner = this.getGeneratorModel().getBaseClassMapping().get(baseType);
        GenAspectOperation aspectAccept = GenAspectOperation.create(accept.getName(), accept.getParameters(), accept.getState(), owner);
        aspectAccept.getGenerics().addAll(accept.getGenerics());
        GenAspect aspectForBaseTypeExpansion = this.getGeneratorModel().getAspectForBaseTypeExpansion(baseType);
        aspectForBaseTypeExpansion.addAspectOperation(aspectAccept);
    }

    private void assumeClassAndAddOperation(GenType genType, final GenJavaOperation accept) {
        genType.accept(new GenTypeVisitor(){

            @Override
            public void handle(Generic generic) {
            }

            @Override
            public void handle(GenMapType mapType) {
            }

            @Override
            public void handle(GenPrimitiveType primitiveType) {
            }

            @Override
            public void handle(GenCollectionType collectionType) {
            }

            @Override
            public void handle(GenClass cla) {
                cla.addOperation(accept);
            }

            @Override
            public void handle(GenJavaUtilCollection javaUtilCollection) {
            }

            @Override
            public void handle(GenImportType importType) {
            }

            @Override
            public void handle(GenDummyType dummy) {
            }
        });
    }

    private GenJavaOperation copyOperation(GenJavaOperation op) throws TaskException {
        String name = op.getName();
        ArrayList<Generic> generics = this.copyGenerics(op.getGenerics());
        List<GenParameter> params = this.copyParams(op.getParameters());
        GenOperationState opState = this.copyOperationState(op.getState());
        GenJavaOperation newOp = GenJavaOperation.create(name, params, opState);
        newOp.getGenerics().addAll(generics);
        return newOp;
    }

    private GenOperationState copyOperationState(GenOperationState state) throws TaskException {
        return state.accept(new GenOperationStateVisitorReturnException<GenOperationState, TaskException>(){

            @Override
            public GenOperationState handle(GenSimpleOperationState s) throws TaskException {
                return GenSimpleOperationState.create(s.getFullOperationWithPossibleImplementation());
            }

            @Override
            public GenOperationState handle(GenFullParsedOperationState s) throws TaskException {
                return GenFullParsedOperationState.create(s.getComment(), VisitorTypeTransformer.this.copyException(s.getExceptions()), s.getReturntyp(), s.getModifiers(), s.getVisibility(), s.getMethodBody());
            }
        });
    }

    private Collection<GenException> copyException(Collection<GenException> exceptions) throws TaskException {
        Vector<GenException> result = new Vector<GenException>();
        for (GenException current : exceptions) {
            result.add(GenException.create(current.getName(), this.copyOperations(current.getOperations()), current.getImplement(), this.copyExceptionAttributes(current.getAttributes()), current.getModifieres(), current.getConstructors(), current.getPackag(), current.getComment(), current.getNonGeneratedPart()));
        }
        return result;
    }

    private Collection<GenJavaOperation> copyOperations(Collection<GenJavaOperation> operations) throws TaskException {
        Vector<GenJavaOperation> result = new Vector<GenJavaOperation>();
        for (GenJavaOperation current : operations) {
            result.add(this.copyOperation(current));
        }
        return result;
    }

    private Collection<GenJavaAttribute> copyExceptionAttributes(Collection<GenJavaAttribute> attributes) {
        return attributes;
    }

    private List<GenParameter> copyParams(List<GenParameter> parameters) {
        ArrayList<GenParameter> result = new ArrayList<GenParameter>();
        for (GenParameter current : parameters) {
            result.add(GenParameter.create(current.getName(), current.getTyp()));
        }
        return result;
    }

    private ArrayList<Generic> copyGenerics(ArrayList<Generic> generics) {
        ArrayList<Generic> result = new ArrayList<Generic>();
        for (Generic current : generics) {
            result.add(Generic.create(current.getGenericName(), current.getGenericType()));
        }
        return result;
    }

    public GeneratorModel getGeneratorModel() {
        return this.generatorModel;
    }

    public GenException getCurrentException() {
        return this.currentException;
    }

    public void setCurrentException(GenException currentException) {
        this.currentException = currentException;
    }

    public GenType getCurrentReturnType() {
        return this.currentReturnType;
    }

    public void setCurrentReturnType(GenType currentReturnType) {
        this.currentReturnType = currentReturnType;
    }

    public boolean hasTypeHandled(GenInterfaceClass visitor, GenType handledType) {
        List<GenType> list = this.handledTypes.get(visitor);
        return list != null && list.contains(handledType);
    }

    public void addHandledType(GenInterfaceClass visitor, GenType handledType) {
        List<GenType> list = this.handledTypes.get(visitor);
        if (list == null) {
            list = new ArrayList<GenType>();
            this.handledTypes.put(visitor, list);
        }
        list.add(handledType);
    }

    public void beginTask() throws TaskException {
    }

    public void finalizeTask() throws TaskException {
    }
}

