package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;

/**
 * This visitor handles all GenClass-types. Maybe throws an exception.
 * 
 * @param <Y>
 *            The type of exception that can be thrown by handle-methods.
 */
public interface GenClassVisitorException<Y extends Exception> {
	
	/**
	 * Handle method for objects of GenClassClass-type.
	 * 
	 * @param classClass
	 *            GenClassClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenClassClass classClass) throws Y;
	
	/**
	 * Handle method for objects of GenInterfaceClass-type.
	 * 
	 * @param interfaceClass
	 *            GenInterfaceClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenInterfaceClass interfaceClass) throws Y;
	
	/**
	 * Handle method for objects of GenPrimitiveClass-type.
	 * 
	 * @param primitiveClass
	 *            GenPrimitiveClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenPrimitiveClass primitiveClass) throws Y;
}
